/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.toolspec.Tool;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.Form;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CommandLineParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CommandLineParser.class);
    private ToolSpec toolspec;

    public CommandLineParser(ToolSpec ts) {
        this.toolspec = ts;
    }

    public void setToolSpec(ToolSpec ts) {
        this.toolspec = ts;
    }

    public static String[] getArgsFromString(String s) {
        StringTokenizer toker = new StringTokenizer(s);
        ArrayList<String> res = new ArrayList<String>();
        while (toker.hasMoreTokens()) {
            res.add(toker.nextToken());
        }
        return res.toArray(new String[res.size()]);
    }

    public CommandDocument parseArguments(String args) throws BadUsageException {
        return this.parseArguments(CommandLineParser.getArgsFromString(args));
    }

    public CommandDocument parseArguments(String[] args) throws BadUsageException {
        ErrorVisitor errors;
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder debugMsg = new StringBuilder("Parsing arguments: ");
            for (int i = 0; i < args.length; ++i) {
                debugMsg.append(args[i]).append(" ");
            }
            LOG.fine(debugMsg.toString());
        }
        if (this.toolspec == null) {
            throw new IllegalStateException("No schema known- call to acceptSchema() must be made and must succeed");
        }
        Document resultDoc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            resultDoc = factory.newDocumentBuilder().newDocument();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "FAIL_CREATE_DOM_MSG");
        }
        Element commandEl = resultDoc.createElementNS("http://cxf.apache.org/Xutil/Command", "command");
        Attr attr = commandEl.getOwnerDocument().createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
        attr.setValue("http://cxf.apache.org/Xutil/Command http://cxf.apache.org/schema/xutil/commnad.xsd");
        commandEl.setAttributeNodeNS(attr);
        commandEl.setAttribute("xmlns", "http://cxf.apache.org/Xutil/Command");
        commandEl.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        resultDoc.appendChild(commandEl);
        TokenInputStream tokens = new TokenInputStream(args);
        Element usage = this.toolspec.getUsage();
        List<Element> usageForms = this.toolspec.getUsageForms();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Found " + usageForms.size() + " alternative forms of usage, will use default form");
        }
        if (usageForms.size() > 0) {
            errors = new ErrorVisitor();
            for (Element elem : usageForms) {
                Form form = new Form(elem);
                int pos = tokens.getPosition();
                if (form.accept(tokens, commandEl, errors)) {
                    commandEl.setAttribute("form", form.getName());
                    break;
                }
                tokens.setPosition(pos);
                if (elem.getNextSibling() != null) continue;
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("No more forms left to try, returning null");
                }
                this.throwUsage(errors);
            }
        } else {
            Form form = new Form(usage);
            errors = new ErrorVisitor();
            if (!form.accept(tokens, commandEl, errors)) {
                this.throwUsage(errors);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            try {
                Transformer serializer = TransformerFactory.newInstance().newTransformer(new StreamSource(Tool.class.getResourceAsStream("indent-no-xml-declaration.xsl")));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                serializer.transform(new DOMSource(resultDoc), new StreamResult(os));
                LOG.fine(((Object)os).toString());
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "ERROR_SERIALIZE_COMMAND_MSG", ex);
            }
        }
        return new CommandDocument(this.toolspec, resultDoc);
    }

    public void throwUsage(ErrorVisitor errors) throws BadUsageException {
        try {
            throw new BadUsageException(this.getUsage(), errors);
        }
        catch (TransformerException ex) {
            LOG.log(Level.SEVERE, "CANNOT_GET_USAGE_MSG", ex);
            throw new BadUsageException(errors);
        }
    }

    public String getUsage() throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = this.getClass().getResourceAsStream("usage.xsl");
        this.toolspec.transform(in, baos);
        return baos.toString();
    }

    public String getDetailedUsage() throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.toolspec.transform(this.getClass().getResourceAsStream("detailedUsage.xsl"), baos);
        return baos.toString();
    }

    public String getFormattedDetailedUsage() throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.toolspec.transform(this.getClass().getResourceAsStream("detailedUsage.xsl"), baos);
        String usage = baos.toString();
        int beforeOptSpan = 3;
        int optSize = 12;
        int afterOptLen = 6;
        int totalLen = 80;
        int optSpan = optSize + afterOptLen - 1;
        int beforeDesSpan = beforeOptSpan + optSpan + 1;
        String lineSeparator = System.getProperty("line.separator");
        StringTokenizer st1 = new StringTokenizer(usage, lineSeparator);
        int i = 0;
        int length = st1.countTokens();
        String[] originalStrs = new String[length];
        while (st1.hasMoreTokens()) {
            String str;
            originalStrs[i] = str = st1.nextToken();
            ++i;
        }
        StringBuilder strbuffer = new StringBuilder();
        for (int j = 0; j < length - 1; j += 2) {
            int optionLen = originalStrs[j].length();
            this.addWhiteNamespace(strbuffer, beforeOptSpan);
            if (optionLen <= optSpan) {
                strbuffer.append(originalStrs[j]);
                this.addWhiteNamespace(strbuffer, optSpan - originalStrs[j].length());
                strbuffer.append(" ");
                if (originalStrs[j + 1].length() > totalLen - beforeDesSpan) {
                    int lastIdx = totalLen - beforeDesSpan;
                    int lastIdx2 = this.splitAndAppendText(strbuffer, originalStrs[j + 1], 0, lastIdx);
                    originalStrs[j + 1] = originalStrs[j + 1].substring(lastIdx2);
                    strbuffer.append(lineSeparator);
                } else {
                    strbuffer.append(originalStrs[j + 1]);
                    strbuffer.append(lineSeparator);
                    originalStrs[j + 1] = "";
                }
            } else {
                strbuffer.append(originalStrs[j]);
                strbuffer.append(lineSeparator);
            }
            String tmpStr = originalStrs[j + 1];
            for (i = 0; i < tmpStr.length(); i += totalLen - beforeDesSpan) {
                if (i + totalLen - beforeDesSpan < tmpStr.length()) {
                    this.addWhiteNamespace(strbuffer, beforeDesSpan);
                    int lastIdx = i + totalLen - beforeDesSpan;
                    int lastIdx2 = this.splitAndAppendText(strbuffer, tmpStr, i, lastIdx);
                    i += lastIdx2 - lastIdx;
                    strbuffer.append(lineSeparator);
                    continue;
                }
                this.addWhiteNamespace(strbuffer, beforeDesSpan);
                strbuffer.append(tmpStr.substring(i));
                strbuffer.append(lineSeparator);
            }
            strbuffer.append(lineSeparator);
        }
        return strbuffer.toString();
    }

    private int splitAndAppendText(StringBuilder buffer, String tmpStr, int idx, int lastIdx) {
        int origLast = lastIdx;
        while (lastIdx > idx && !Character.isWhitespace(tmpStr.charAt(lastIdx))) {
            --lastIdx;
        }
        if (lastIdx == idx) {
            lastIdx = origLast;
        }
        buffer.append(tmpStr.substring(idx, lastIdx));
        if (Character.isWhitespace(tmpStr.charAt(lastIdx))) {
            ++lastIdx;
        }
        return lastIdx;
    }

    private void addWhiteNamespace(StringBuilder strbuffer, int count) {
        for (int i = 0; i < count; ++i) {
            strbuffer.append(" ");
        }
    }

    public String getDetailedUsage(String id) {
        String result = null;
        Element element = this.toolspec.getElementById(id);
        List annotations = DOMUtils.findAllElementsByTagNameNS((Element)element, (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"annotation");
        if (annotations != null && annotations.size() > 0) {
            result = ((Element)annotations.get(0)).getFirstChild().getNodeValue();
        }
        return result;
    }

    public String getToolUsage() {
        return this.toolspec.getAnnotation();
    }
}

