/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.RemoteFetchingCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;

public final class GetCacheEntryCommand
extends AbstractDataCommand
implements RemoteFetchingCommand {
    public static final byte COMMAND_ID = 45;
    private InternalEntryFactory entryFactory;
    private InternalCacheEntry remotelyFetchedValue;

    public GetCacheEntryCommand(Object key, Set<Flag> flags, InternalEntryFactory entryFactory) {
        this.key = key;
        this.flags = flags;
        this.entryFactory = entryFactory;
    }

    public GetCacheEntryCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetCacheEntryCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry == null || entry.isNull()) {
            return null;
        }
        if (entry.isRemoved()) {
            return null;
        }
        return this.entryFactory.copy(entry);
    }

    @Override
    public byte getCommandId() {
        return 45;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 45) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.flags = (Set)parameters[1];
    }

    @Override
    public void setRemotelyFetchedValue(InternalCacheEntry remotelyFetchedValue) {
        this.remotelyFetchedValue = remotelyFetchedValue;
    }

    @Override
    public InternalCacheEntry getRemotelyFetchedValue() {
        return this.remotelyFetchedValue;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, Flag.copyWithoutRemotableFlags(this.flags)};
    }

    @Override
    public String toString() {
        return "GetCacheEntryCommand {key=" + Util.toStr((Object)this.key) + ", flags=" + this.flags + "}";
    }
}

