/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.util.Arrays;
import org.apache.lucene.facet.taxonomy.AssociationFacetField;
import org.apache.lucene.util.BytesRef;

public class IntAssociationFacetField
extends AssociationFacetField {
    public IntAssociationFacetField(int assoc, String dim, String ... path) {
        super(IntAssociationFacetField.intToBytesRef(assoc), dim, path);
    }

    public static BytesRef intToBytesRef(int v) {
        byte[] bytes = new byte[]{(byte)(v >> 24), (byte)(v >> 16), (byte)(v >> 8), (byte)v};
        return new BytesRef(bytes);
    }

    public static int bytesRefToInt(BytesRef b) {
        return (b.bytes[b.offset] & 0xFF) << 24 | (b.bytes[b.offset + 1] & 0xFF) << 16 | (b.bytes[b.offset + 2] & 0xFF) << 8 | b.bytes[b.offset + 3] & 0xFF;
    }

    @Override
    public String toString() {
        return "IntAssociationFacetField(dim=" + this.dim + " path=" + Arrays.toString(this.path) + " value=" + IntAssociationFacetField.bytesRefToInt(this.assoc) + ")";
    }
}

