/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.util.impl;

import java.util.HashSet;
import java.util.Properties;

public class JNDIHelper {
    public static final String HIBERNATE_JNDI_PREFIX = "hibernate.jndi.";

    private JNDIHelper() {
    }

    public static Properties getJndiProperties(Properties properties, String prefix) {
        HashSet<String> specialProps = new HashSet<String>();
        specialProps.add(prefix + "class");
        specialProps.add(prefix + "url");
        Properties result = JNDIHelper.addJNDIProperties(properties, prefix, specialProps);
        JNDIHelper.handleSpecialPropertyTranslation(properties, prefix + "class", result, "java.naming.factory.initial");
        JNDIHelper.handleSpecialPropertyTranslation(properties, prefix + "url", result, "java.naming.provider.url");
        return result;
    }

    private static Properties addJNDIProperties(Properties properties, String prefix, HashSet<String> specialProps) {
        Properties result = new Properties();
        for (Object property : properties.keySet()) {
            String s;
            if (!(property instanceof String) || (s = (String)property).indexOf(prefix) <= -1 || specialProps.contains(s)) continue;
            result.setProperty(s.substring(prefix.length()), properties.getProperty(s));
        }
        return result;
    }

    private static void handleSpecialPropertyTranslation(Properties originalProperties, String oldKey, Properties newProperties, String newKey) {
        String value = originalProperties.getProperty(oldKey);
        if (value != null) {
            newProperties.put(newKey, value);
        }
    }
}

