/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wsas.activity;

import com.arjuna.mw.wsas.UserActivityFactory;
import com.arjuna.mw.wsas.completionstatus.Failure;
import com.arjuna.mw.wsas.completionstatus.FailureOnly;
import com.arjuna.mw.wsas.logging.wsasLogger;
import com.arjuna.mw.wsas.status.Active;
import com.arjuna.mw.wsas.status.Status;
import com.arjuna.mw.wsas.status.Unknown;
import com.arjuna.mwlabs.wsas.activity.ActivityHierarchyImple;
import com.arjuna.mwlabs.wsas.activity.ActivityImple;
import com.arjuna.mwlabs.wsas.activity.ReaperElement;
import com.arjuna.mwlabs.wsas.activity.ReaperThread;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class ActivityReaper {
    private SortedSet<ReaperElement> _list = new TreeSet<ReaperElement>();
    private static ActivityReaper _theReaper = null;
    private static ReaperThread _reaperThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long sleepPeriod() {
        SortedSet<ReaperElement> sortedSet = this._list;
        synchronized (sortedSet) {
            long firstTimeout;
            if (this._list.isEmpty()) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime >= (firstTimeout = this._list.first()._absoluteTimeout)) {
                return -1L;
            }
            return firstTimeout - currentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean check(long timeout) {
        ReaperElement element = null;
        SortedSet<ReaperElement> sortedSet = this._list;
        synchronized (sortedSet) {
            if (this._list.isEmpty()) {
                return false;
            }
            element = this._list.first();
            if (timeout < element._absoluteTimeout) {
                return false;
            }
        }
        Status status = Unknown.instance();
        try {
            status = element._activity.status();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (status instanceof Active) {
            boolean problem = false;
            try {
                UserActivityFactory.userActivity().resume(new ActivityHierarchyImple(element._activity));
                UserActivityFactory.userActivity().end(Failure.instance());
                UserActivityFactory.userActivity().suspend();
            }
            catch (Exception ex) {
                problem = true;
            }
            if (problem) {
                boolean error = false;
                try {
                    element._activity.setCompletionStatus(FailureOnly.instance());
                }
                catch (Exception ex3) {
                    error = true;
                }
                if (error) {
                    wsasLogger.i18NLogger.warn_activity_ActivityReaper_1();
                }
            }
        }
        SortedSet<ReaperElement> sortedSet2 = this._list;
        synchronized (sortedSet2) {
            this._list.remove(element);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long numberOfActivities() {
        SortedSet<ReaperElement> sortedSet = this._list;
        synchronized (sortedSet) {
            return this._list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean insert(ActivityImple activity, int timeout) {
        if (timeout == 0) {
            return true;
        }
        ReaperElement e = new ReaperElement(activity, timeout);
        Object object = this._list;
        synchronized (object) {
            this._list.add(e);
        }
        object = _reaperThread;
        synchronized (object) {
            _reaperThread.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(ActivityImple act) {
        if (act == null) {
            return false;
        }
        boolean found = false;
        Object object = this._list;
        synchronized (object) {
            Iterator iter = this._list.iterator();
            ReaperElement e = null;
            while (iter.hasNext() && !found) {
                e = (ReaperElement)iter.next();
                if (!e._activity.equals(act)) continue;
                this._list.remove(e);
                found = true;
            }
        }
        if (found) {
            object = _reaperThread;
            synchronized (object) {
                _reaperThread.notify();
            }
        }
        return false;
    }

    public static synchronized ActivityReaper create() {
        if (_theReaper == null) {
            _theReaper = new ActivityReaper();
            _reaperThread = new ReaperThread(_theReaper);
            _reaperThread.setDaemon(true);
            _reaperThread.start();
        }
        return _theReaper;
    }

    public static synchronized ActivityReaper activityReaper() {
        return ActivityReaper.activityReaper(false);
    }

    public static synchronized ActivityReaper activityReaper(boolean createReaper) {
        if (createReaper) {
            return ActivityReaper.create();
        }
        return _theReaper;
    }

    public static synchronized void shutdown() {
        if (_theReaper != null) {
            _reaperThread.shutdown();
        }
    }

    ActivityReaper() {
    }

    static final void reset() {
        _theReaper = null;
    }
}

