/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.logging;

import java.io.IOException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYTX", length=4)
public interface TransactionLogger
extends BasicLogger {
    public static final TransactionLogger ROOT_LOGGER = (TransactionLogger)Logger.getMessageLogger(TransactionLogger.class, (String)"org.jboss.as.txn");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Unable to roll back active transaction")
    public void unableToRollBack(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Unable to get transaction state")
    public void unableToGetTransactionStatus(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="APPLICATION ERROR: transaction still active in request with status %s")
    public void transactionStillOpen(int var1);

    @Message(id=4, value="Create failed")
    public StartException createFailed(@Cause Throwable var1);

    @Message(id=5, value="%s manager create failed")
    public StartException managerStartFailure(@Cause Throwable var1, String var2);

    @Message(id=6, value="Failed to configure object store browser bean")
    public StartException objectStoreStartFailure(@Cause Throwable var1);

    @Message(id=7, value="Service not started")
    public IllegalStateException serviceNotStarted();

    @Message(id=8, value="Start failed")
    public StartException startFailure(@Cause Throwable var1);

    @Message(id=9, value="Unknown metric %s")
    public String unknownMetric(Object var1);

    @Message(id=10, value="MBean Server service not installed, this functionality is not available if the JMX subsystem has not been installed.")
    public RuntimeException jmxSubsystemNotInstalled();

    @Message(id=11, value="'hornetq-store-enable-async-io' must be true.")
    public String transformHornetQStoreEnableAsyncIoMustBeTrue();

    @Message(id=12, value="Attributes %s and %s are alternatives; both cannot be set with conflicting values.")
    public OperationFailedException inconsistentStatisticsSettings(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="Node identifier property is set to the default value. Please make sure it is unique.")
    public void nodeIdentifierIsSetToDefault();

    @Message(id=14, value="Jndi name is required")
    public OperationFailedException jndiNameRequired();

    @Message(id=15, value="Jndi names have to start with java:/ or java:jboss/")
    public OperationFailedException jndiNameInvalidFormat();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="Transaction started in EE Concurrent invocation left open, starting rollback to prevent leak.")
    public void rollbackOfTransactionStartedInEEConcurrentInvocation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Failed to rollback transaction.")
    public void failedToRollbackTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="Failed to suspend transaction.")
    public void failedToSuspendTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="System error while checking for transaction leak in EE Concurrent invocation.")
    public void systemErrorWhileCheckingForTransactionLeak(@Cause Throwable var1);

    @Message(id=20, value="EE Concurrent ContextHandle serialization must be handled by the factory.")
    public IOException serializationMustBeHandledByTheFactory();

    @Message(id=21, value="EE Concurrent's TransactionSetupProviderService not started.")
    public IllegalStateException transactionSetupProviderServiceNotStarted();

    @Message(id=22, value="EE Concurrent's TransactionSetupProviderService not installed.")
    public IllegalStateException transactionSetupProviderServiceNotInstalled();

    @Message(id=23, value="%s must be undefined if %s is 'true'.")
    public OperationFailedException mustBeUndefinedIfTrue(String var1, String var2);

    @Message(id=24, value="%s must be defined if %s is defined.")
    public OperationFailedException mustBedefinedIfDefined(String var1, String var2);

    @Message(id=25, value="Either %s must be 'true' or  %s must be defined.")
    public OperationFailedException eitherTrueOrDefined(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=26, value="The transaction %s could not be removed from the cache during cleanup.")
    public void transactionNotFound(Transaction var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=27, value="The pre-jca synchronization %s associated with tx %s failed during after completion")
    public void preJcaSyncAfterCompletionFailed(Synchronization var1, Transaction var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=28, value="The jca synchronization %s associated with tx %s failed during after completion")
    public void jcaSyncAfterCompletionFailed(Synchronization var1, Transaction var2, @Cause Exception var3);

    @Message(id=29, value="Syncs are not allowed to be registered when the tx is in state %s")
    public IllegalStateException syncsnotallowed(int var1);
}

