/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import com.arjuna.ats.arjuna.coordinator.TxStats;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TxStatsHandler
extends AbstractRuntimeOnlyHandler {
    public static final TxStatsHandler INSTANCE = new TxStatsHandler();
    private final TxStats txStats = TxStats.getInstance();

    private TxStatsHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        TxStat stat = TxStat.getStat(operation.require("name").asString());
        if (stat == null) {
            context.getFailureDescription().set(TransactionLogger.ROOT_LOGGER.unknownMetric(operation.require("name").asString()));
        } else {
            ModelNode result = new ModelNode();
            switch (stat) {
                case NUMBER_OF_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfTransactions());
                    break;
                }
                case NUMBER_OF_NESTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfNestedTransactions());
                    break;
                }
                case NUMBER_OF_HEURISTICS: {
                    result.set(this.txStats.getNumberOfHeuristics());
                    break;
                }
                case NUMBER_OF_COMMITTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfCommittedTransactions());
                    break;
                }
                case NUMBER_OF_ABORTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfAbortedTransactions());
                    break;
                }
                case NUMBER_OF_INFLIGHT_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfInflightTransactions());
                    break;
                }
                case NUMBER_OF_TIMED_OUT_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfTimedOutTransactions());
                    break;
                }
                case NUMBER_OF_APPLICATION_ROLLBACKS: {
                    result.set(this.txStats.getNumberOfApplicationRollbacks());
                    break;
                }
                case NUMBER_OF_RESOURCE_ROLLBACKS: {
                    result.set(this.txStats.getNumberOfResourceRollbacks());
                    break;
                }
                default: {
                    throw new IllegalStateException(TransactionLogger.ROOT_LOGGER.unknownMetric((Object)stat));
                }
            }
            context.getResult().set(result);
        }
        context.stepCompleted();
    }

    void registerMetrics(ManagementResourceRegistration resourceRegistration) {
        for (TxStat stat : TxStat.values()) {
            resourceRegistration.registerMetric(stat.definition, (OperationStepHandler)this);
        }
    }

    public static enum TxStat {
        NUMBER_OF_TRANSACTIONS((AttributeDefinition)new SimpleAttributeDefinition("number-of-transactions", ModelType.LONG, true)),
        NUMBER_OF_NESTED_TRANSACTIONS((AttributeDefinition)new SimpleAttributeDefinition("number-of-nested-transactions", ModelType.LONG, true)),
        NUMBER_OF_HEURISTICS((AttributeDefinition)new SimpleAttributeDefinition("number-of-heuristics", ModelType.LONG, true)),
        NUMBER_OF_COMMITTED_TRANSACTIONS((AttributeDefinition)new SimpleAttributeDefinition("number-of-committed-transactions", ModelType.LONG, true)),
        NUMBER_OF_ABORTED_TRANSACTIONS((AttributeDefinition)new SimpleAttributeDefinition("number-of-aborted-transactions", ModelType.LONG, true)),
        NUMBER_OF_INFLIGHT_TRANSACTIONS((AttributeDefinition)new SimpleAttributeDefinition("number-of-inflight-transactions", ModelType.LONG, true)),
        NUMBER_OF_TIMED_OUT_TRANSACTIONS((AttributeDefinition)new SimpleAttributeDefinition("number-of-timed-out-transactions", ModelType.LONG, true)),
        NUMBER_OF_APPLICATION_ROLLBACKS((AttributeDefinition)new SimpleAttributeDefinition("number-of-application-rollbacks", ModelType.LONG, true)),
        NUMBER_OF_RESOURCE_ROLLBACKS((AttributeDefinition)new SimpleAttributeDefinition("number-of-resource-rollbacks", ModelType.LONG, true));

        private static final Map<String, TxStat> MAP;
        final AttributeDefinition definition;

        private TxStat(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static synchronized TxStat getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, TxStat>();
            for (TxStat stat : EnumSet.allOf(TxStat.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }
}

