/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class SimpleImmutableSessionMetaData
implements ImmutableSessionMetaData {
    private final boolean isNew;
    private final boolean expired;
    private final Date creationTime;
    private final Date lastAccessedTime;
    private final long maxInactiveInterval;

    public SimpleImmutableSessionMetaData(ImmutableSessionMetaData metaData) {
        this.isNew = metaData.isNew();
        this.expired = metaData.isExpired();
        this.creationTime = metaData.getCreationTime();
        this.lastAccessedTime = metaData.getLastAccessedTime();
        this.maxInactiveInterval = metaData.getMaxInactiveInterval(TimeUnit.MILLISECONDS);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public long getMaxInactiveInterval(TimeUnit unit) {
        return unit.convert(this.maxInactiveInterval, TimeUnit.MILLISECONDS);
    }
}

