/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.spi.EntityInstrumentationMetadata;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.ValueInclusion;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.Component;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.InDatabaseValueGenerationStrategy;
import org.hibernate.tuple.InMemoryValueGenerationStrategy;
import org.hibernate.tuple.NonIdentifierAttribute;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.ValueGeneration;
import org.hibernate.tuple.ValueGenerator;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.hibernate.tuple.entity.NonPojoInstrumentationMetadata;
import org.hibernate.tuple.entity.VersionProperty;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class EntityMetamodel
implements Serializable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityMetamodel.class.getName());
    private static final int NO_VERSION_INDX = -66;
    private final SessionFactoryImplementor sessionFactory;
    private final AbstractEntityPersister persister;
    private final String name;
    private final String rootName;
    private final EntityType entityType;
    private final IdentifierProperty identifierAttribute;
    private final boolean versioned;
    private final int propertySpan;
    private final int versionPropertyIndex;
    private final NonIdentifierAttribute[] properties;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyLaziness;
    private final boolean[] propertyUpdateability;
    private final boolean[] nonlazyPropertyUpdateability;
    private final boolean[] propertyCheckability;
    private final boolean[] propertyInsertability;
    private final boolean[] propertyNullability;
    private final boolean[] propertyVersionability;
    private final CascadeStyle[] cascadeStyles;
    private final boolean hasPreInsertGeneratedValues;
    private final boolean hasPreUpdateGeneratedValues;
    private final boolean hasInsertGeneratedValues;
    private final boolean hasUpdateGeneratedValues;
    private final InMemoryValueGenerationStrategy[] inMemoryValueGenerationStrategies;
    private final InDatabaseValueGenerationStrategy[] inDatabaseValueGenerationStrategies;
    private final Map<String, Integer> propertyIndexes = new HashMap<String, Integer>();
    private final boolean hasCollections;
    private final boolean hasMutableProperties;
    private final boolean hasLazyProperties;
    private final boolean hasNonIdentifierPropertyNamedId;
    private final int[] naturalIdPropertyNumbers;
    private final boolean hasImmutableNaturalId;
    private final boolean hasCacheableNaturalId;
    private boolean lazy;
    private final boolean hasCascades;
    private final boolean mutable;
    private final boolean isAbstract;
    private final boolean selectBeforeUpdate;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final OptimisticLockStyle optimisticLockStyle;
    private final boolean polymorphic;
    private final String superclass;
    private final boolean explicitPolymorphism;
    private final boolean inherited;
    private final boolean hasSubclasses;
    private final Set subclassEntityNames = new HashSet();
    private final Map entityNameByInheritenceClassMap = new HashMap();
    private final EntityMode entityMode;
    private final EntityTuplizer entityTuplizer;
    private final EntityInstrumentationMetadata instrumentationMetadata;
    private static final GenerationStrategyPair NO_GEN_PAIR = new GenerationStrategyPair();

    public EntityMetamodel(PersistentClass persistentClass, AbstractEntityPersister persister, SessionFactoryImplementor sessionFactory) {
        boolean isAllOrDirty;
        this.sessionFactory = sessionFactory;
        this.persister = persister;
        this.name = persistentClass.getEntityName();
        this.rootName = persistentClass.getRootClass().getEntityName();
        this.entityType = sessionFactory.getTypeResolver().getTypeFactory().manyToOne(this.name);
        this.identifierAttribute = PropertyFactory.buildIdentifierAttribute(persistentClass, sessionFactory.getIdentifierGenerator(this.rootName));
        this.versioned = persistentClass.isVersioned();
        this.instrumentationMetadata = persistentClass.hasPojoRepresentation() ? Environment.getBytecodeProvider().getEntityInstrumentationMetadata(persistentClass.getMappedClass()) : new NonPojoInstrumentationMetadata(persistentClass.getEntityName());
        boolean hasLazy = false;
        this.propertySpan = persistentClass.getPropertyClosureSpan();
        this.properties = new NonIdentifierAttribute[this.propertySpan];
        ArrayList<Integer> naturalIdNumbers = new ArrayList<Integer>();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.nonlazyPropertyUpdateability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.cascadeStyles = new CascadeStyle[this.propertySpan];
        this.inMemoryValueGenerationStrategies = new InMemoryValueGenerationStrategy[this.propertySpan];
        this.inDatabaseValueGenerationStrategies = new InDatabaseValueGenerationStrategy[this.propertySpan];
        boolean foundPreInsertGeneratedValues = false;
        boolean foundPreUpdateGeneratedValues = false;
        boolean foundPostInsertGeneratedValues = false;
        boolean foundPostUpdateGeneratedValues = false;
        Iterator iter = persistentClass.getPropertyClosureIterator();
        int i = 0;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        boolean foundCollection = false;
        boolean foundMutable = false;
        boolean foundNonIdentifierPropertyNamedId = false;
        boolean foundInsertGeneratedValue = false;
        boolean foundUpdateGeneratedValue = false;
        boolean foundUpdateableNaturalIdProperty = false;
        while (iter.hasNext()) {
            ValueGenerator generator;
            GenerationTiming timing;
            boolean lazy;
            Property prop = (Property)iter.next();
            if (prop == persistentClass.getVersion()) {
                tempVersionProperty = i;
                this.properties[i] = PropertyFactory.buildVersionProperty(persister, sessionFactory, i, prop, this.instrumentationMetadata.isInstrumented());
            } else {
                this.properties[i] = PropertyFactory.buildEntityBasedAttribute(persister, sessionFactory, i, prop, this.instrumentationMetadata.isInstrumented());
            }
            if (prop.isNaturalIdentifier()) {
                naturalIdNumbers.add(i);
                if (prop.isUpdateable()) {
                    foundUpdateableNaturalIdProperty = true;
                }
            }
            if ("id".equals(prop.getName())) {
                foundNonIdentifierPropertyNamedId = true;
            }
            boolean bl = lazy = prop.isLazy() && this.instrumentationMetadata.isInstrumented();
            if (lazy) {
                hasLazy = true;
            }
            this.propertyLaziness[i] = lazy;
            this.propertyNames[i] = this.properties[i].getName();
            this.propertyTypes[i] = this.properties[i].getType();
            this.propertyNullability[i] = this.properties[i].isNullable();
            this.propertyUpdateability[i] = this.properties[i].isUpdateable();
            this.propertyInsertability[i] = this.properties[i].isInsertable();
            this.propertyVersionability[i] = this.properties[i].isVersionable();
            this.nonlazyPropertyUpdateability[i] = this.properties[i].isUpdateable() && !lazy;
            this.propertyCheckability[i] = this.propertyUpdateability[i] || this.propertyTypes[i].isAssociationType() && ((AssociationType)this.propertyTypes[i]).isAlwaysDirtyChecked();
            this.cascadeStyles[i] = this.properties[i].getCascadeStyle();
            GenerationStrategyPair pair = EntityMetamodel.buildGenerationStrategyPair(sessionFactory, prop);
            this.inMemoryValueGenerationStrategies[i] = pair.getInMemoryStrategy();
            this.inDatabaseValueGenerationStrategies[i] = pair.getInDatabaseStrategy();
            if (pair.getInMemoryStrategy() != null && (timing = pair.getInMemoryStrategy().getGenerationTiming()) != GenerationTiming.NEVER && (generator = pair.getInMemoryStrategy().getValueGenerator()) != null) {
                if (timing == GenerationTiming.INSERT) {
                    foundPreInsertGeneratedValues = true;
                } else if (timing == GenerationTiming.ALWAYS) {
                    foundPreInsertGeneratedValues = true;
                    foundPreUpdateGeneratedValues = true;
                }
            }
            if (pair.getInDatabaseStrategy() != null) {
                timing = pair.getInDatabaseStrategy().getGenerationTiming();
                if (timing == GenerationTiming.INSERT) {
                    foundPostInsertGeneratedValues = true;
                } else if (timing == GenerationTiming.ALWAYS) {
                    foundPostInsertGeneratedValues = true;
                    foundPostUpdateGeneratedValues = true;
                }
            }
            if (this.properties[i].isLazy()) {
                hasLazy = true;
            }
            if (this.properties[i].getCascadeStyle() != CascadeStyles.NONE) {
                foundCascade = true;
            }
            if (this.indicatesCollection(this.properties[i].getType())) {
                foundCollection = true;
            }
            if (this.propertyTypes[i].isMutable() && this.propertyCheckability[i]) {
                foundMutable = true;
            }
            this.mapPropertyToIndex(prop, i);
            ++i;
        }
        if (naturalIdNumbers.size() == 0) {
            this.naturalIdPropertyNumbers = null;
            this.hasImmutableNaturalId = false;
            this.hasCacheableNaturalId = false;
        } else {
            this.naturalIdPropertyNumbers = ArrayHelper.toIntArray(naturalIdNumbers);
            this.hasImmutableNaturalId = !foundUpdateableNaturalIdProperty;
            this.hasCacheableNaturalId = persistentClass.getNaturalIdCacheRegionName() != null;
        }
        this.hasPreInsertGeneratedValues = foundPreInsertGeneratedValues;
        this.hasPreUpdateGeneratedValues = foundPreUpdateGeneratedValues;
        this.hasInsertGeneratedValues = foundPostInsertGeneratedValues;
        this.hasUpdateGeneratedValues = foundPostUpdateGeneratedValues;
        this.hasCascades = foundCascade;
        this.hasNonIdentifierPropertyNamedId = foundNonIdentifierPropertyNamedId;
        this.versionPropertyIndex = tempVersionProperty;
        this.hasLazyProperties = hasLazy;
        if (this.hasLazyProperties) {
            LOG.lazyPropertyFetchingAvailable(this.name);
        }
        this.lazy = persistentClass.isLazy() && (!persistentClass.hasPojoRepresentation() || !ReflectHelper.isFinalClass(persistentClass.getProxyInterface()));
        this.mutable = persistentClass.isMutable();
        if (persistentClass.isAbstract() == null) {
            this.isAbstract = persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass());
        } else {
            this.isAbstract = persistentClass.isAbstract();
            if (!this.isAbstract && persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass())) {
                LOG.entityMappedAsNonAbstract(this.name);
            }
        }
        this.selectBeforeUpdate = persistentClass.hasSelectBeforeUpdate();
        this.dynamicUpdate = persistentClass.useDynamicUpdate();
        this.dynamicInsert = persistentClass.useDynamicInsert();
        this.polymorphic = persistentClass.isPolymorphic();
        this.explicitPolymorphism = persistentClass.isExplicitPolymorphism();
        this.inherited = persistentClass.isInherited();
        this.superclass = this.inherited ? persistentClass.getSuperclass().getEntityName() : null;
        this.hasSubclasses = persistentClass.hasSubclasses();
        this.optimisticLockStyle = persistentClass.getOptimisticLockStyle();
        boolean bl = isAllOrDirty = this.optimisticLockStyle == OptimisticLockStyle.ALL || this.optimisticLockStyle == OptimisticLockStyle.DIRTY;
        if (isAllOrDirty && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock=all|dirty requires dynamic-update=\"true\": " + this.name);
        }
        if (this.versionPropertyIndex != -66 && isAllOrDirty) {
            throw new MappingException("version and optimistic-lock=all|dirty are not a valid combination : " + this.name);
        }
        this.hasCollections = foundCollection;
        this.hasMutableProperties = foundMutable;
        iter = persistentClass.getSubclassIterator();
        while (iter.hasNext()) {
            this.subclassEntityNames.add(((PersistentClass)iter.next()).getEntityName());
        }
        this.subclassEntityNames.add(this.name);
        if (persistentClass.hasPojoRepresentation()) {
            this.entityNameByInheritenceClassMap.put(persistentClass.getMappedClass(), persistentClass.getEntityName());
            iter = persistentClass.getSubclassIterator();
            while (iter.hasNext()) {
                PersistentClass pc = (PersistentClass)iter.next();
                this.entityNameByInheritenceClassMap.put(pc.getMappedClass(), pc.getEntityName());
            }
        }
        this.entityMode = persistentClass.hasPojoRepresentation() ? EntityMode.POJO : EntityMode.MAP;
        EntityTuplizerFactory entityTuplizerFactory = sessionFactory.getSettings().getEntityTuplizerFactory();
        String tuplizerClassName = persistentClass.getTuplizerImplClassName(this.entityMode);
        this.entityTuplizer = tuplizerClassName == null ? entityTuplizerFactory.constructDefaultTuplizer(this.entityMode, this, persistentClass) : entityTuplizerFactory.constructTuplizer(tuplizerClassName, this, persistentClass);
    }

    private static GenerationStrategyPair buildGenerationStrategyPair(SessionFactoryImplementor sessionFactory, Property mappingProperty) {
        ValueGeneration valueGeneration = mappingProperty.getValueGenerationStrategy();
        if (valueGeneration != null && valueGeneration.getGenerationTiming() != GenerationTiming.NEVER) {
            if (valueGeneration.getValueGenerator() != null) {
                return new GenerationStrategyPair(FullInMemoryValueGenerationStrategy.create(valueGeneration));
            }
            return new GenerationStrategyPair(EntityMetamodel.create(sessionFactory, mappingProperty, valueGeneration));
        }
        if (mappingProperty.getValue() instanceof org.hibernate.mapping.Component) {
            CompositeGenerationStrategyPairBuilder builder = new CompositeGenerationStrategyPairBuilder(mappingProperty);
            EntityMetamodel.interpretPartialCompositeValueGeneration(sessionFactory, (org.hibernate.mapping.Component)mappingProperty.getValue(), builder);
            return builder.buildPair();
        }
        return NO_GEN_PAIR;
    }

    private static void interpretPartialCompositeValueGeneration(SessionFactoryImplementor sessionFactory, org.hibernate.mapping.Component composite, CompositeGenerationStrategyPairBuilder builder) {
        Iterator subProperties = composite.getPropertyIterator();
        while (subProperties.hasNext()) {
            Property subProperty = (Property)subProperties.next();
            builder.addPair(EntityMetamodel.buildGenerationStrategyPair(sessionFactory, subProperty));
        }
    }

    public static InDatabaseValueGenerationStrategyImpl create(SessionFactoryImplementor sessionFactoryImplementor, Property mappingProperty, ValueGeneration valueGeneration) {
        int numberOfMappedColumns = mappingProperty.getType().getColumnSpan(sessionFactoryImplementor);
        if (numberOfMappedColumns == 1) {
            return new InDatabaseValueGenerationStrategyImpl(valueGeneration.getGenerationTiming(), valueGeneration.referenceColumnInSql(), new String[]{valueGeneration.getDatabaseGeneratedReferencedColumnValue()});
        }
        if (valueGeneration.getDatabaseGeneratedReferencedColumnValue() != null) {
            LOG.debugf("Value generator specified column value in reference to multi-column attribute [%s -> %s]; ignoring", mappingProperty.getPersistentClass(), mappingProperty.getName());
        }
        return new InDatabaseValueGenerationStrategyImpl(valueGeneration.getGenerationTiming(), valueGeneration.referenceColumnInSql(), new String[numberOfMappedColumns]);
    }

    private ValueInclusion determineInsertValueGenerationType(Property mappingProperty, NonIdentifierAttribute runtimeProperty) {
        if (this.isInsertGenerated(runtimeProperty)) {
            return ValueInclusion.FULL;
        }
        if (mappingProperty.getValue() instanceof org.hibernate.mapping.Component && this.hasPartialInsertComponentGeneration((org.hibernate.mapping.Component)mappingProperty.getValue())) {
            return ValueInclusion.PARTIAL;
        }
        return ValueInclusion.NONE;
    }

    private boolean isInsertGenerated(NonIdentifierAttribute property) {
        return property.getValueGenerationStrategy() != null && property.getValueGenerationStrategy().getGenerationTiming() != GenerationTiming.NEVER;
    }

    private boolean isInsertGenerated(Property property) {
        return property.getValueGenerationStrategy() != null && property.getValueGenerationStrategy().getGenerationTiming() != GenerationTiming.NEVER;
    }

    public EntityMetamodel(EntityBinding entityBinding, AbstractEntityPersister persister, SessionFactoryImplementor sessionFactory) {
        boolean isAllOrDirty;
        this.sessionFactory = sessionFactory;
        this.persister = persister;
        this.name = entityBinding.getEntity().getName();
        this.rootName = entityBinding.getHierarchyDetails().getRootEntityBinding().getEntity().getName();
        this.entityType = sessionFactory.getTypeResolver().getTypeFactory().manyToOne(this.name);
        this.identifierAttribute = PropertyFactory.buildIdentifierProperty(entityBinding, sessionFactory.getIdentifierGenerator(this.rootName));
        this.versioned = entityBinding.isVersioned();
        boolean hasPojoRepresentation = false;
        Class<?> mappedClass = null;
        Class<?> proxyInterfaceClass = null;
        if (entityBinding.getEntity().getClassReferenceUnresolved() != null) {
            hasPojoRepresentation = true;
            mappedClass = entityBinding.getEntity().getClassReference();
            proxyInterfaceClass = entityBinding.getProxyInterfaceType().getValue();
        }
        this.instrumentationMetadata = Environment.getBytecodeProvider().getEntityInstrumentationMetadata(mappedClass);
        boolean hasLazy = false;
        BasicAttributeBinding rootEntityIdentifier = entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding();
        this.propertySpan = rootEntityIdentifier == null ? entityBinding.getAttributeBindingClosureSpan() : entityBinding.getAttributeBindingClosureSpan() - 1;
        this.properties = new NonIdentifierAttribute[this.propertySpan];
        ArrayList naturalIdNumbers = new ArrayList();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.nonlazyPropertyUpdateability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.cascadeStyles = new CascadeStyle[this.propertySpan];
        this.hasPreInsertGeneratedValues = false;
        this.hasPreUpdateGeneratedValues = false;
        this.hasInsertGeneratedValues = false;
        this.hasUpdateGeneratedValues = false;
        this.inMemoryValueGenerationStrategies = new InMemoryValueGenerationStrategy[this.propertySpan];
        Arrays.fill(this.inMemoryValueGenerationStrategies, NoInMemoryValueGenerationStrategy.INSTANCE);
        this.inDatabaseValueGenerationStrategies = new InDatabaseValueGenerationStrategy[this.propertySpan];
        Arrays.fill(this.inDatabaseValueGenerationStrategies, NoInDatabaseValueGenerationStrategy.INSTANCE);
        int i = 0;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        boolean foundCollection = false;
        boolean foundMutable = false;
        boolean foundNonIdentifierPropertyNamedId = false;
        boolean foundInsertGeneratedValue = false;
        boolean foundUpdateGeneratedValue = false;
        boolean foundUpdateableNaturalIdProperty = false;
        for (AttributeBinding attributeBinding : entityBinding.getAttributeBindingClosure()) {
            boolean lazy;
            if (attributeBinding == rootEntityIdentifier) continue;
            if (attributeBinding == entityBinding.getHierarchyDetails().getVersioningAttributeBinding()) {
                tempVersionProperty = i;
                this.properties[i] = PropertyFactory.buildVersionProperty(persister, entityBinding.getHierarchyDetails().getVersioningAttributeBinding(), this.instrumentationMetadata.isInstrumented());
            } else {
                this.properties[i] = PropertyFactory.buildStandardProperty(attributeBinding, this.instrumentationMetadata.isInstrumented());
            }
            if ("id".equals(attributeBinding.getAttribute().getName())) {
                foundNonIdentifierPropertyNamedId = true;
            }
            boolean bl = lazy = attributeBinding.isLazy() && this.instrumentationMetadata.isInstrumented();
            if (lazy) {
                hasLazy = true;
            }
            this.propertyLaziness[i] = lazy;
            this.propertyNames[i] = this.properties[i].getName();
            this.propertyTypes[i] = this.properties[i].getType();
            this.propertyNullability[i] = this.properties[i].isNullable();
            this.propertyUpdateability[i] = this.properties[i].isUpdateable();
            this.propertyInsertability[i] = this.properties[i].isInsertable();
            this.propertyVersionability[i] = this.properties[i].isVersionable();
            this.nonlazyPropertyUpdateability[i] = this.properties[i].isUpdateable() && !lazy;
            this.propertyCheckability[i] = this.propertyUpdateability[i] || this.propertyTypes[i].isAssociationType() && ((AssociationType)this.propertyTypes[i]).isAlwaysDirtyChecked();
            this.cascadeStyles[i] = this.properties[i].getCascadeStyle();
            if (this.properties[i].isLazy()) {
                hasLazy = true;
            }
            if (this.properties[i].getCascadeStyle() != CascadeStyles.NONE) {
                foundCascade = true;
            }
            if (this.indicatesCollection(this.properties[i].getType())) {
                foundCollection = true;
            }
            if (this.propertyTypes[i].isMutable() && this.propertyCheckability[i]) {
                foundMutable = true;
            }
            this.mapPropertyToIndex(attributeBinding.getAttribute(), i);
            ++i;
        }
        if (naturalIdNumbers.size() == 0) {
            this.naturalIdPropertyNumbers = null;
            this.hasImmutableNaturalId = false;
            this.hasCacheableNaturalId = false;
        } else {
            this.naturalIdPropertyNumbers = ArrayHelper.toIntArray(naturalIdNumbers);
            this.hasImmutableNaturalId = !foundUpdateableNaturalIdProperty;
            this.hasCacheableNaturalId = false;
        }
        this.hasCascades = foundCascade;
        this.hasNonIdentifierPropertyNamedId = foundNonIdentifierPropertyNamedId;
        this.versionPropertyIndex = tempVersionProperty;
        this.hasLazyProperties = hasLazy;
        if (this.hasLazyProperties) {
            LOG.lazyPropertyFetchingAvailable(this.name);
        }
        this.lazy = entityBinding.isLazy() && (!hasPojoRepresentation || !ReflectHelper.isFinalClass(proxyInterfaceClass));
        this.mutable = entityBinding.isMutable();
        if (entityBinding.isAbstract() == null) {
            this.isAbstract = hasPojoRepresentation && ReflectHelper.isAbstractClass(mappedClass);
        } else {
            this.isAbstract = entityBinding.isAbstract();
            if (!this.isAbstract && hasPojoRepresentation && ReflectHelper.isAbstractClass(mappedClass)) {
                LOG.entityMappedAsNonAbstract(this.name);
            }
        }
        this.selectBeforeUpdate = entityBinding.isSelectBeforeUpdate();
        this.dynamicUpdate = entityBinding.isDynamicUpdate();
        this.dynamicInsert = entityBinding.isDynamicInsert();
        this.hasSubclasses = entityBinding.hasSubEntityBindings();
        this.polymorphic = entityBinding.isPolymorphic();
        this.explicitPolymorphism = entityBinding.getHierarchyDetails().isExplicitPolymorphism();
        this.inherited = !entityBinding.isRoot();
        this.superclass = this.inherited ? entityBinding.getEntity().getSuperType().getName() : null;
        this.optimisticLockStyle = entityBinding.getHierarchyDetails().getOptimisticLockStyle();
        boolean bl = isAllOrDirty = this.optimisticLockStyle == OptimisticLockStyle.ALL || this.optimisticLockStyle == OptimisticLockStyle.DIRTY;
        if (isAllOrDirty && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock=all|dirty requires dynamic-update=\"true\": " + this.name);
        }
        if (this.versionPropertyIndex != -66 && isAllOrDirty) {
            throw new MappingException("version and optimistic-lock=all|dirty are not a valid combination : " + this.name);
        }
        this.hasCollections = foundCollection;
        this.hasMutableProperties = foundMutable;
        for (EntityBinding subEntityBinding : entityBinding.getPostOrderSubEntityBindingClosure()) {
            this.subclassEntityNames.add(subEntityBinding.getEntity().getName());
            if (subEntityBinding.getEntity().getClassReference() == null) continue;
            this.entityNameByInheritenceClassMap.put(subEntityBinding.getEntity().getClassReference(), subEntityBinding.getEntity().getName());
        }
        this.subclassEntityNames.add(this.name);
        if (mappedClass != null) {
            this.entityNameByInheritenceClassMap.put(mappedClass, this.name);
        }
        this.entityMode = hasPojoRepresentation ? EntityMode.POJO : EntityMode.MAP;
        EntityTuplizerFactory entityTuplizerFactory = sessionFactory.getSettings().getEntityTuplizerFactory();
        Class<? extends EntityTuplizer> tuplizerClass = entityBinding.getCustomEntityTuplizerClass();
        this.entityTuplizer = tuplizerClass == null ? entityTuplizerFactory.constructDefaultTuplizer(this.entityMode, this, entityBinding) : entityTuplizerFactory.constructTuplizer(tuplizerClass, this, entityBinding);
    }

    private ValueInclusion determineInsertValueGenerationType(AttributeBinding mappingProperty, NonIdentifierAttribute runtimeProperty) {
        if (this.isInsertGenerated(runtimeProperty)) {
            return ValueInclusion.FULL;
        }
        return ValueInclusion.NONE;
    }

    private boolean hasPartialInsertComponentGeneration(org.hibernate.mapping.Component component) {
        Iterator subProperties = component.getPropertyIterator();
        while (subProperties.hasNext()) {
            Property prop = (Property)subProperties.next();
            if (this.isInsertGenerated(prop)) {
                return true;
            }
            if (!(prop.getValue() instanceof org.hibernate.mapping.Component) || !this.hasPartialInsertComponentGeneration((org.hibernate.mapping.Component)prop.getValue())) continue;
            return true;
        }
        return false;
    }

    private ValueInclusion determineUpdateValueGenerationType(Property mappingProperty, NonIdentifierAttribute runtimeProperty) {
        if (EntityMetamodel.isUpdateGenerated(runtimeProperty)) {
            return ValueInclusion.FULL;
        }
        if (mappingProperty.getValue() instanceof org.hibernate.mapping.Component && this.hasPartialUpdateComponentGeneration((org.hibernate.mapping.Component)mappingProperty.getValue())) {
            return ValueInclusion.PARTIAL;
        }
        return ValueInclusion.NONE;
    }

    private static boolean isUpdateGenerated(Property property) {
        return property.getValueGenerationStrategy() != null && property.getValueGenerationStrategy().getGenerationTiming() == GenerationTiming.ALWAYS;
    }

    private static boolean isUpdateGenerated(NonIdentifierAttribute property) {
        return property.getValueGenerationStrategy() != null && property.getValueGenerationStrategy().getGenerationTiming() == GenerationTiming.ALWAYS;
    }

    private ValueInclusion determineUpdateValueGenerationType(AttributeBinding mappingProperty, NonIdentifierAttribute runtimeProperty) {
        if (EntityMetamodel.isUpdateGenerated(runtimeProperty)) {
            return ValueInclusion.FULL;
        }
        return ValueInclusion.NONE;
    }

    private boolean hasPartialUpdateComponentGeneration(org.hibernate.mapping.Component component) {
        Iterator subProperties = component.getPropertyIterator();
        while (subProperties.hasNext()) {
            Property prop = (Property)subProperties.next();
            if (EntityMetamodel.isUpdateGenerated(prop)) {
                return true;
            }
            if (!(prop.getValue() instanceof org.hibernate.mapping.Component) || !this.hasPartialUpdateComponentGeneration((org.hibernate.mapping.Component)prop.getValue())) continue;
            return true;
        }
        return false;
    }

    private void mapPropertyToIndex(Property prop, int i) {
        this.propertyIndexes.put(prop.getName(), i);
        if (prop.getValue() instanceof org.hibernate.mapping.Component) {
            Iterator iter = ((org.hibernate.mapping.Component)prop.getValue()).getPropertyIterator();
            while (iter.hasNext()) {
                Property subprop = (Property)iter.next();
                this.propertyIndexes.put(prop.getName() + '.' + subprop.getName(), i);
            }
        }
    }

    private void mapPropertyToIndex(Attribute attribute, int i) {
        this.propertyIndexes.put(attribute.getName(), i);
        if (attribute.isSingular() && ((SingularAttribute)attribute).getSingularAttributeType().isComponent()) {
            Component component = (Component)((SingularAttribute)attribute).getSingularAttributeType();
            for (Attribute subAttribute : component.attributes()) {
                this.propertyIndexes.put(attribute.getName() + '.' + subAttribute.getName(), i);
            }
        }
    }

    public EntityTuplizer getTuplizer() {
        return this.entityTuplizer;
    }

    public boolean isNaturalIdentifierInsertGenerated() {
        InDatabaseValueGenerationStrategy strategy = this.inDatabaseValueGenerationStrategies[this.naturalIdPropertyNumbers[0]];
        return strategy != null && strategy.getGenerationTiming() != GenerationTiming.NEVER;
    }

    public boolean isVersionGenerated() {
        InDatabaseValueGenerationStrategy strategy = this.inDatabaseValueGenerationStrategies[this.versionPropertyIndex];
        return strategy != null && strategy.getGenerationTiming() != GenerationTiming.NEVER;
    }

    public int[] getNaturalIdentifierProperties() {
        return this.naturalIdPropertyNumbers;
    }

    public boolean hasNaturalIdentifier() {
        return this.naturalIdPropertyNumbers != null;
    }

    public boolean isNaturalIdentifierCached() {
        return this.hasNaturalIdentifier() && this.hasCacheableNaturalId;
    }

    public boolean hasImmutableNaturalId() {
        return this.hasImmutableNaturalId;
    }

    public Set getSubclassEntityNames() {
        return this.subclassEntityNames;
    }

    private boolean indicatesCollection(Type type) {
        if (type.isCollectionType()) {
            return true;
        }
        if (type.isComponentType()) {
            Type[] subtypes = ((CompositeType)type).getSubtypes();
            for (int i = 0; i < subtypes.length; ++i) {
                if (!this.indicatesCollection(subtypes[i])) continue;
                return true;
            }
        }
        return false;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public String getName() {
        return this.name;
    }

    public String getRootName() {
        return this.rootName;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public IdentifierProperty getIdentifierProperty() {
        return this.identifierAttribute;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public int getVersionPropertyIndex() {
        return this.versionPropertyIndex;
    }

    public VersionProperty getVersionProperty() {
        if (-66 == this.versionPropertyIndex) {
            return null;
        }
        return (VersionProperty)this.properties[this.versionPropertyIndex];
    }

    public NonIdentifierAttribute[] getProperties() {
        return this.properties;
    }

    public int getPropertyIndex(String propertyName) {
        Integer index = this.getPropertyIndexOrNull(propertyName);
        if (index == null) {
            throw new HibernateException("Unable to resolve property: " + propertyName);
        }
        return index;
    }

    public Integer getPropertyIndexOrNull(String propertyName) {
        return this.propertyIndexes.get(propertyName);
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean hasMutableProperties() {
        return this.hasMutableProperties;
    }

    public boolean hasNonIdentifierPropertyNamedId() {
        return this.hasNonIdentifierPropertyNamedId;
    }

    public boolean hasLazyProperties() {
        return this.hasLazyProperties;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String findEntityNameByEntityClass(Class inheritenceClass) {
        return (String)this.entityNameByInheritenceClassMap.get(inheritenceClass);
    }

    public String toString() {
        return "EntityMetamodel(" + this.name + ':' + ArrayHelper.toString(this.properties) + ')';
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public boolean[] getPropertyLaziness() {
        return this.propertyLaziness;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    public boolean[] getPropertyCheckability() {
        return this.propertyCheckability;
    }

    public boolean[] getNonlazyPropertyUpdateability() {
        return this.nonlazyPropertyUpdateability;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean[] getPropertyVersionability() {
        return this.propertyVersionability;
    }

    public CascadeStyle[] getCascadeStyles() {
        return this.cascadeStyles;
    }

    public boolean hasPreInsertGeneratedValues() {
        return this.hasPreInsertGeneratedValues;
    }

    public boolean hasPreUpdateGeneratedValues() {
        return this.hasPreUpdateGeneratedValues;
    }

    public boolean hasInsertGeneratedValues() {
        return this.hasInsertGeneratedValues;
    }

    public boolean hasUpdateGeneratedValues() {
        return this.hasUpdateGeneratedValues;
    }

    public InMemoryValueGenerationStrategy[] getInMemoryValueGenerationStrategies() {
        return this.inMemoryValueGenerationStrategies;
    }

    public InDatabaseValueGenerationStrategy[] getInDatabaseValueGenerationStrategies() {
        return this.inDatabaseValueGenerationStrategies;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public boolean isInstrumented() {
        return this.instrumentationMetadata.isInstrumented();
    }

    public EntityInstrumentationMetadata getInstrumentationMetadata() {
        return this.instrumentationMetadata;
    }

    private static class InDatabaseValueGenerationStrategyImpl
    implements InDatabaseValueGenerationStrategy {
        private final GenerationTiming timing;
        private final boolean referenceColumnInSql;
        private final String[] referencedColumnValues;

        private InDatabaseValueGenerationStrategyImpl(GenerationTiming timing, boolean referenceColumnInSql, String[] referencedColumnValues) {
            this.timing = timing;
            this.referenceColumnInSql = referenceColumnInSql;
            this.referencedColumnValues = referencedColumnValues;
        }

        @Override
        public GenerationTiming getGenerationTiming() {
            return this.timing;
        }

        @Override
        public boolean referenceColumnsInSql() {
            return this.referenceColumnInSql;
        }

        @Override
        public String[] getReferencedColumnValues() {
            return this.referencedColumnValues;
        }
    }

    private static class NoInDatabaseValueGenerationStrategy
    implements InDatabaseValueGenerationStrategy {
        public static final NoInDatabaseValueGenerationStrategy INSTANCE = new NoInDatabaseValueGenerationStrategy();

        private NoInDatabaseValueGenerationStrategy() {
        }

        @Override
        public GenerationTiming getGenerationTiming() {
            return GenerationTiming.NEVER;
        }

        @Override
        public boolean referenceColumnsInSql() {
            return true;
        }

        @Override
        public String[] getReferencedColumnValues() {
            return null;
        }
    }

    private static class FullInMemoryValueGenerationStrategy
    implements InMemoryValueGenerationStrategy {
        private final GenerationTiming timing;
        private final ValueGenerator generator;

        private FullInMemoryValueGenerationStrategy(GenerationTiming timing, ValueGenerator generator) {
            this.timing = timing;
            this.generator = generator;
        }

        public static FullInMemoryValueGenerationStrategy create(ValueGeneration valueGeneration) {
            return new FullInMemoryValueGenerationStrategy(valueGeneration.getGenerationTiming(), valueGeneration.getValueGenerator());
        }

        @Override
        public GenerationTiming getGenerationTiming() {
            return this.timing;
        }

        @Override
        public ValueGenerator getValueGenerator() {
            return this.generator;
        }
    }

    private static class NoInMemoryValueGenerationStrategy
    implements InMemoryValueGenerationStrategy {
        public static final NoInMemoryValueGenerationStrategy INSTANCE = new NoInMemoryValueGenerationStrategy();

        private NoInMemoryValueGenerationStrategy() {
        }

        @Override
        public GenerationTiming getGenerationTiming() {
            return GenerationTiming.NEVER;
        }

        @Override
        public ValueGenerator getValueGenerator() {
            return null;
        }
    }

    private static class CompositeGenerationStrategyPairBuilder {
        private final Property mappingProperty;
        private boolean hadInMemoryGeneration;
        private boolean hadInDatabaseGeneration;
        private List<InMemoryValueGenerationStrategy> inMemoryStrategies;
        private List<InDatabaseValueGenerationStrategy> inDatabaseStrategies;

        public CompositeGenerationStrategyPairBuilder(Property mappingProperty) {
            this.mappingProperty = mappingProperty;
        }

        public void addPair(GenerationStrategyPair generationStrategyPair) {
            this.add(generationStrategyPair.getInMemoryStrategy());
            this.add(generationStrategyPair.getInDatabaseStrategy());
        }

        private void add(InMemoryValueGenerationStrategy inMemoryStrategy) {
            if (this.inMemoryStrategies == null) {
                this.inMemoryStrategies = new ArrayList<InMemoryValueGenerationStrategy>();
            }
            this.inMemoryStrategies.add(inMemoryStrategy);
            if (inMemoryStrategy.getGenerationTiming() != GenerationTiming.NEVER) {
                this.hadInMemoryGeneration = true;
            }
        }

        private void add(InDatabaseValueGenerationStrategy inDatabaseStrategy) {
            if (this.inDatabaseStrategies == null) {
                this.inDatabaseStrategies = new ArrayList<InDatabaseValueGenerationStrategy>();
            }
            this.inDatabaseStrategies.add(inDatabaseStrategy);
            if (inDatabaseStrategy.getGenerationTiming() != GenerationTiming.NEVER) {
                this.hadInDatabaseGeneration = true;
            }
        }

        public GenerationStrategyPair buildPair() {
            if (this.hadInMemoryGeneration && this.hadInDatabaseGeneration) {
                throw new ValueGenerationStrategyException("Composite attribute [" + this.mappingProperty.getName() + "] contained both in-memory" + " and in-database value generation");
            }
            if (this.hadInMemoryGeneration) {
                throw new NotYetImplementedException("Still need to wire in composite in-memory value generation");
            }
            if (this.hadInDatabaseGeneration) {
                org.hibernate.mapping.Component composite = (org.hibernate.mapping.Component)this.mappingProperty.getValue();
                if (this.inDatabaseStrategies.size() != composite.getPropertySpan()) {
                    throw new ValueGenerationStrategyException("Internal error : mismatch between number of collected in-db generation strategies and number of attributes for composite attribute : " + this.mappingProperty.getName());
                }
                GenerationTiming timing = GenerationTiming.INSERT;
                boolean referenceColumns = false;
                String[] columnValues = new String[composite.getColumnSpan()];
                int propertyIndex = -1;
                int columnIndex = 0;
                Iterator subProperties = composite.getPropertyIterator();
                while (subProperties.hasNext()) {
                    InDatabaseValueGenerationStrategy subStrategy;
                    Property subProperty = (Property)subProperties.next();
                    if ((subStrategy = this.inDatabaseStrategies.get(++propertyIndex)).getGenerationTiming() == GenerationTiming.ALWAYS) {
                        timing = GenerationTiming.ALWAYS;
                    }
                    if (subStrategy.referenceColumnsInSql()) {
                        referenceColumns = true;
                    }
                    if (subStrategy.getReferencedColumnValues() == null) continue;
                    if (subStrategy.getReferencedColumnValues().length != subProperty.getColumnSpan()) {
                        throw new ValueGenerationStrategyException("Internal error : mismatch between number of collected 'referenced column values' and number of columns for composite attribute : " + this.mappingProperty.getName() + '.' + subProperty.getName());
                    }
                    System.arraycopy(subStrategy.getReferencedColumnValues(), 0, columnValues, columnIndex, subProperty.getColumnSpan());
                }
                return new GenerationStrategyPair(new InDatabaseValueGenerationStrategyImpl(timing, referenceColumns, columnValues));
            }
            return NO_GEN_PAIR;
        }
    }

    public static class ValueGenerationStrategyException
    extends HibernateException {
        public ValueGenerationStrategyException(String message) {
            super(message);
        }

        public ValueGenerationStrategyException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class GenerationStrategyPair {
        private final InMemoryValueGenerationStrategy inMemoryStrategy;
        private final InDatabaseValueGenerationStrategy inDatabaseStrategy;

        public GenerationStrategyPair() {
            this(NoInMemoryValueGenerationStrategy.INSTANCE, NoInDatabaseValueGenerationStrategy.INSTANCE);
        }

        public GenerationStrategyPair(FullInMemoryValueGenerationStrategy inMemoryStrategy) {
            this(inMemoryStrategy, NoInDatabaseValueGenerationStrategy.INSTANCE);
        }

        public GenerationStrategyPair(InDatabaseValueGenerationStrategyImpl inDatabaseStrategy) {
            this(NoInMemoryValueGenerationStrategy.INSTANCE, inDatabaseStrategy);
        }

        public GenerationStrategyPair(InMemoryValueGenerationStrategy inMemoryStrategy, InDatabaseValueGenerationStrategy inDatabaseStrategy) {
            if (inMemoryStrategy == null) {
                inMemoryStrategy = NoInMemoryValueGenerationStrategy.INSTANCE;
            }
            if (inDatabaseStrategy == null) {
                inDatabaseStrategy = NoInDatabaseValueGenerationStrategy.INSTANCE;
            }
            if (inMemoryStrategy.getGenerationTiming() != GenerationTiming.NEVER && inDatabaseStrategy.getGenerationTiming() != GenerationTiming.NEVER) {
                throw new ValueGenerationStrategyException("in-memory and in-database value generation are mutually exclusive");
            }
            this.inMemoryStrategy = inMemoryStrategy;
            this.inDatabaseStrategy = inDatabaseStrategy;
        }

        public InMemoryValueGenerationStrategy getInMemoryStrategy() {
            return this.inMemoryStrategy;
        }

        public InDatabaseValueGenerationStrategy getInDatabaseStrategy() {
            return this.inDatabaseStrategy;
        }
    }
}

