/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.gssapi;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.sasl.JBossSaslProvider;
import org.jboss.sasl.gssapi.GssapiServer;
import org.jboss.sasl.gssapi.SubjectFactory;
import org.jboss.sasl.gssapi.SubjectIdentity;

public class GssapiServerFactory
implements SaslServerFactory {
    public static final String GSSAPI = "GSSAPI";
    static final String SUBJECT_FACTORY = "org.jboss.sasl.gssapi.subject_factory";
    private static final String GSSAPI_KEY = SaslServerFactory.class.getSimpleName() + "." + "GSSAPI";

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (props.containsKey(SUBJECT_FACTORY) && this.findFactoryForGssapi(props) != null) {
            return new String[]{GSSAPI};
        }
        return new String[0];
    }

    @Override
    public SaslServer createSaslServer(final String mechanism, final String protocol, final String serverName, final Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        SubjectIdentity identity;
        SaslServerFactory saslFactory;
        SubjectFactory factory = (SubjectFactory)props.get(SUBJECT_FACTORY);
        if (factory != null && (saslFactory = this.findFactoryForGssapi(props)) != null && (identity = factory.getSubjectIdentity(protocol, serverName)) != null) {
            try {
                return Subject.doAs(identity.getSubject(), new PrivilegedExceptionAction<SaslServer>(){

                    @Override
                    public SaslServer run() throws SaslException {
                        SaslServer realServer = saslFactory.createSaslServer(mechanism, protocol, serverName, props, cbh);
                        return new GssapiServer(identity, realServer);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                identity.dispose();
                throw (SaslException)e.getException();
            }
        }
        return null;
    }

    private SaslServerFactory findFactoryForGssapi(Map<String, ?> props) {
        Provider[] providers;
        for (Provider current : providers = Security.getProviders()) {
            String gssapiFactory;
            if (current instanceof JBossSaslProvider || (gssapiFactory = current.getProperty(GSSAPI_KEY)) == null) continue;
            try {
                SaslServerFactory theFactory = Class.forName(gssapiFactory, true, current.getClass().getClassLoader()).asSubclass(SaslServerFactory.class).newInstance();
                for (String mech : theFactory.getMechanismNames(props)) {
                    if (!GSSAPI.equals(mech)) continue;
                    return theFactory;
                }
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }
}

