/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportOutput;

public class ByteHolder {
    private final ByteBuffer _bytes;

    ByteHolder(int capacity) {
        this._bytes = ByteBuffer.allocate(capacity);
    }

    public boolean hasSpace() {
        return this._bytes.remaining() > 0;
    }

    public int writeOutputFrom(TransportOutput transportOutput) {
        byte[] byteArray = this._bytes.array();
        int offset = this._bytes.position();
        int numberOfBytesToGet = this._bytes.remaining();
        int numberOfBytesGot = transportOutput.output(byteArray, offset, numberOfBytesToGet);
        int newPosition = offset + numberOfBytesGot;
        this._bytes.position(newPosition);
        return newPosition;
    }

    public ByteBuffer prepareToRead() {
        this._bytes.flip();
        return this._bytes;
    }

    public int readInto(byte[] destination, int offset, int numberOfBytesRequested) {
        int numberOfBytesToRead = Math.min(numberOfBytesRequested, this._bytes.remaining());
        this._bytes.get(destination, offset, numberOfBytesToRead);
        return numberOfBytesToRead;
    }

    public boolean readInto(TransportInput transportInput) {
        if (this._bytes.hasRemaining()) {
            int offset = this._bytes.position();
            int numberAccepted = transportInput.input(this._bytes.array(), offset, this._bytes.remaining());
            int newPosition = offset + numberAccepted;
            this._bytes.position(newPosition);
            return !this._bytes.hasRemaining();
        }
        return true;
    }

    public ByteBuffer prepareToWrite() {
        this._bytes.compact();
        return this._bytes;
    }

    public int getCapacity() {
        return this._bytes.capacity();
    }
}

