/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class DefaultResourceAddDescriptionProvider
implements DescriptionProvider {
    private final ImmutableManagementResourceRegistration registration;
    final ResourceDescriptionResolver descriptionResolver;

    public DefaultResourceAddDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver) {
        this.registration = registration;
        this.descriptionResolver = descriptionResolver;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode result = new ModelNode();
        ResourceBundle bundle = this.descriptionResolver.getResourceBundle(locale);
        result.get("operation-name").set("add");
        result.get("description").set(this.descriptionResolver.getOperationDescription("add", locale, bundle));
        Set<String> attributeNames = this.registration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        TreeMap<AttributeDefinition.NameAndGroup, ModelNode> sortedDescriptions = new TreeMap<AttributeDefinition.NameAndGroup, ModelNode>();
        for (String attr : attributeNames) {
            AttributeAccess attributeAccess = this.registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attr);
            if (attributeAccess.getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
            AttributeDefinition def = attributeAccess.getAttributeDefinition();
            if (def != null) {
                if (def.isResourceOnly()) continue;
                ModelNode attrDesc = new ModelNode();
                def.addOperationParameterDescription(attrDesc, "add", this.descriptionResolver, locale, bundle);
                sortedDescriptions.put(new AttributeDefinition.NameAndGroup(def), attrDesc.get(new String[]{"request-properties", attr}));
                continue;
            }
            sortedDescriptions.put(new AttributeDefinition.NameAndGroup(attr), new ModelNode());
        }
        ModelNode params = result.get("request-properties").setEmptyObject();
        for (Map.Entry entry : sortedDescriptions.entrySet()) {
            params.get(((AttributeDefinition.NameAndGroup)entry.getKey()).getName()).set((ModelNode)entry.getValue());
        }
        result.get("reply-properties").setEmptyObject();
        return result;
    }
}

