/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.EnhancedSyntaxSupport;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WriteAttributeHandler
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("write-attribute", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.NAME, GlobalOperationAttributes.VALUE).build();
    public static final OperationStepHandler INSTANCE = new WriteAttributeHandler();

    WriteAttributeHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model;
        String attributeName;
        String attributeExpression;
        GlobalOperationAttributes.NAME.validateOperation(operation);
        ModelNode nameModel = GlobalOperationAttributes.NAME.resolveModelAttribute(context, operation);
        final PathAddress address = context.getCurrentAddress();
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        if (registry == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(address));
        }
        final boolean useEnhancedSyntax = EnhancedSyntaxSupport.containsEnhancedSyntax(nameModel.asString());
        if (useEnhancedSyntax) {
            attributeExpression = nameModel.asString();
            attributeName = EnhancedSyntaxSupport.extractAttributeName(nameModel.asString());
        } else {
            attributeExpression = attributeName = nameModel.asString();
        }
        final AttributeAccess attributeAccess = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        if (attributeAccess == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.unknownAttribute(attributeName));
        }
        if (attributeAccess.getAccessType() != AttributeAccess.AccessType.READ_WRITE) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.attributeNotWritable(attributeName));
        }
        ModelNode currentValue = attributeAccess.getStorageType() == AttributeAccess.Storage.CONFIGURATION ? ((model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel()).has(attributeName) ? model.get(attributeName) : new ModelNode()) : new ModelNode();
        AuthorizationResult authorizationResult = context.authorize(operation, attributeName, currentValue);
        if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.require("operation").asString(), address, authorizationResult.getExplanation());
        }
        if (attributeAccess.getStorageType() == AttributeAccess.Storage.CONFIGURATION && !registry.isRuntimeOnly()) {
            ModelNode oldValue = currentValue.clone();
            this.doExecuteInternal(context, operation, attributeAccess, attributeName, currentValue, useEnhancedSyntax, attributeExpression);
            ModelNode model2 = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode newValue = model2.has(attributeName) ? model2.get(attributeName) : new ModelNode();
            this.emitAttributeValueWrittenNotification(context, address, attributeName, oldValue, newValue);
        } else {
            assert (attributeAccess.getStorageType() == AttributeAccess.Storage.RUNTIME);
            OperationContext.Stage currentStage = context.getCurrentStage();
            ModelNode readAttributeOperation = Util.createOperation("read-attribute", address);
            readAttributeOperation.get(GlobalOperationAttributes.NAME.getName()).set(attributeName);
            ReadAttributeHandler readAttributeHandler = new ReadAttributeHandler(null, null, false);
            final ModelNode oldValue = new ModelNode();
            final ModelNode newValue = new ModelNode();
            context.addStep(oldValue, readAttributeOperation, readAttributeHandler, currentStage);
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    WriteAttributeHandler.this.doExecuteInternal(context, operation, attributeAccess, attributeName, oldValue.get("result"), useEnhancedSyntax, attributeExpression);
                }
            }, currentStage);
            context.addStep(newValue, readAttributeOperation, readAttributeHandler, currentStage);
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    WriteAttributeHandler.this.emitAttributeValueWrittenNotification(context, address, attributeName, oldValue.get("result"), newValue.get("result"));
                }
            }, currentStage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteInternal(OperationContext context, ModelNode operation, AttributeAccess attributeAccess, String attributeName, ModelNode currentValue, boolean useEnhancedSyntax, String attributeExpression) throws OperationFailedException {
        if (useEnhancedSyntax) {
            operation = this.getEnhancedSyntaxResolvedOperation(operation, currentValue, attributeName, attributeExpression);
        }
        OperationStepHandler writeHandler = attributeAccess.getWriteHandler();
        ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(writeHandler.getClass());
        try {
            writeHandler.execute(context, operation);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    private void emitAttributeValueWrittenNotification(OperationContext context, PathAddress address, String attributeName, ModelNode oldValue, ModelNode newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        ModelNode data = new ModelNode();
        data.get(GlobalOperationAttributes.NAME.getName()).set(attributeName);
        data.get("old-value").set(oldValue);
        data.get("new-value").set(newValue);
        Notification notification = new Notification("attribute-value-written", address, ControllerLogger.ROOT_LOGGER.attributeValueWritten(attributeName, oldValue, newValue), data);
        context.emit(notification);
    }

    private ModelNode getEnhancedSyntaxResolvedOperation(ModelNode originalOperation, ModelNode currentModel, String attributeName, String attributeExpression) throws OperationFailedException {
        ModelNode writeOp = originalOperation.clone();
        ModelNode diffValue = originalOperation.get("value");
        ModelNode old = new ModelNode();
        old.get(attributeName).set(currentModel);
        ModelNode fullValue = EnhancedSyntaxSupport.updateWithEnhancedSyntax(attributeExpression, old, diffValue);
        writeOp.get("name").set(attributeName);
        writeOp.get("value").set(fullValue.get(attributeName));
        return writeOp;
    }
}

