/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AbstractTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilderImpl;
import org.jboss.as.controller.transform.description.ConcreteAttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.DiscardTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilder;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilderImpl;
import org.jboss.as.controller.transform.description.RejectTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;

class ResourceTransformationDescriptionBuilderImpl
extends AbstractTransformationDescriptionBuilder
implements ResourceTransformationDescriptionBuilder {
    private final List<String> discardedOperations = new LinkedList<String>();
    private DiscardPolicy discardPolicy = DiscardPolicy.NEVER;
    private final AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry registry = new AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry();

    protected ResourceTransformationDescriptionBuilderImpl(PathElement pathElement) {
        this(pathElement, PathAddressTransformer.DEFAULT);
    }

    protected ResourceTransformationDescriptionBuilderImpl(PathElement pathElement, PathAddressTransformer pathAddressTransformer) {
        super(pathElement, pathAddressTransformer, ResourceTransformer.DEFAULT, OperationTransformer.DEFAULT);
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildResource(PathElement pathElement) {
        ResourceTransformationDescriptionBuilderImpl builder = new ResourceTransformationDescriptionBuilderImpl(pathElement);
        this.children.add(builder);
        return builder;
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildResource(ResourceDefinition definition) {
        return this.addChildResource(definition.getPathElement());
    }

    @Override
    public DiscardTransformationDescriptionBuilder discardChildResource(PathElement pathElement) {
        DiscardTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createDiscardInstance(pathElement);
        this.children.add(builder);
        return builder;
    }

    @Override
    public RejectTransformationDescriptionBuilder rejectChildResource(PathElement pathElement) {
        RejectTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createRejectInstance(pathElement);
        this.children.add(builder);
        return builder;
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildRedirection(PathElement current, PathElement legacy) {
        PathAddressTransformer transformation;
        if (legacy.isWildcard()) {
            assert (current.isWildcard()) : "legacy is wildcard while current is not";
            transformation = new PathAddressTransformer.ReplaceElementKey(legacy.getKey());
        } else {
            assert (!current.isWildcard()) : "legacy is fixed while current is not";
            transformation = new PathAddressTransformer.BasicPathAddressTransformer(legacy);
        }
        return this.addChildRedirection(current, transformation);
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildRedirection(PathElement oldAddress, PathAddressTransformer pathAddressTransformer) {
        ResourceTransformationDescriptionBuilderImpl builder = new ResourceTransformationDescriptionBuilderImpl(oldAddress, pathAddressTransformer);
        this.children.add(builder);
        return builder;
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildBuilder(TransformationDescriptionBuilder builder) {
        this.children.add(builder);
        return this;
    }

    @Override
    public ResourceTransformationDescriptionBuilder setCustomResourceTransformer(ResourceTransformer resourceTransformer) {
        super.setResourceTransformer(resourceTransformer);
        return this;
    }

    @Override
    public TransformationDescription build() {
        return this.buildDefault(this.discardPolicy, false, this.registry, this.discardedOperations);
    }

    @Override
    public OperationTransformationOverrideBuilder addOperationTransformationOverride(String operationName) {
        final OperationTransformationOverrideBuilderImpl transformationBuilder = new OperationTransformationOverrideBuilderImpl(operationName, this);
        this.addOperationTransformerEntry(operationName, new AbstractTransformationDescriptionBuilder.OperationTransformationEntry(){

            @Override
            OperationTransformer getOperationTransformer(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry resourceRegistry) {
                return transformationBuilder.createTransformer(resourceRegistry);
            }
        });
        return transformationBuilder;
    }

    @Override
    public ResourceTransformationDescriptionBuilder addRawOperationTransformationOverride(String operationName, final OperationTransformer operationTransformer) {
        this.addOperationTransformerEntry(operationName, new AbstractTransformationDescriptionBuilder.OperationTransformationEntry(){

            @Override
            OperationTransformer getOperationTransformer(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry resourceRegistry) {
                return operationTransformer;
            }
        });
        return this;
    }

    @Override
    public ConcreteAttributeTransformationDescriptionBuilder getAttributeBuilder() {
        return new ConcreteAttributeTransformationDescriptionBuilder(this, this.registry);
    }

    @Override
    public ResourceTransformationDescriptionBuilder discardOperations(String ... operationNames) {
        Collections.addAll(this.discardedOperations, operationNames);
        return this;
    }
}

