/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.service.AbstractService;
import org.jboss.as.service.component.ServiceComponentInstantiator;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class CreateDestroyService
extends AbstractService {
    private final Method createMethod;
    private final Method destroyMethod;
    private final ServiceComponentInstantiator componentInstantiator;
    private ManagedReference managedReference;

    CreateDestroyService(Object mBeanInstance, Method createMethod, Method destroyMethod, ServiceComponentInstantiator componentInstantiator, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader) {
        super(mBeanInstance, setupActions, mbeanContextClassLoader);
        this.createMethod = createMethod;
        this.destroyMethod = destroyMethod;
        this.componentInstantiator = componentInstantiator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Creating Service: %s", context.getController().getName());
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CreateDestroyService.this.invokeLifecycleMethod(CreateDestroyService.this.createMethod, (LifecycleContext)context);
                    if (CreateDestroyService.this.componentInstantiator != null) {
                        CreateDestroyService.this.managedReference = CreateDestroyService.this.componentInstantiator.initializeInstance(CreateDestroyService.this.getValue());
                    }
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(new StartException(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("create()"), e));
                }
            }
        };
        try {
            ((ExecutorService)this.executor.getValue()).submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Destroying Service: %s", context.getController().getName());
        }
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (CreateDestroyService.this.managedReference != null) {
                        CreateDestroyService.this.managedReference.release();
                    }
                    CreateDestroyService.this.invokeLifecycleMethod(CreateDestroyService.this.destroyMethod, (LifecycleContext)context);
                }
                catch (Exception e) {
                    SarLogger.ROOT_LOGGER.error(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("destroy()"), e);
                }
                finally {
                    context.complete();
                }
            }
        };
        try {
            ((ExecutorService)this.executor.getValue()).submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }
}

