/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.LocationDefinition;
import org.wildfly.extension.undertow.LocationService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterRef;

class LocationAdd
extends AbstractAddStepHandler {
    static LocationAdd INSTANCE = new LocationAdd();

    private LocationAdd() {
        super(new AttributeDefinition[]{LocationDefinition.HANDLER});
    }

    static <T> void addDep(ServiceBuilder<?> b, ServiceName name, Class<T> type, List<InjectedValue<T>> list) {
        InjectedValue v = new InjectedValue();
        b.addDependency(name, type, (Injector)v);
        list.add(v);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress hostAddress = address.subAddress(0, address.size() - 1);
        PathAddress serverAddress = hostAddress.subAddress(0, hostAddress.size() - 1);
        String name = address.getLastElement().getValue();
        String handler = LocationDefinition.HANDLER.resolveModelAttribute(context, model).asString();
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        LocationService service = new LocationService(name);
        String serverName = serverAddress.getLastElement().getValue();
        String hostName = hostAddress.getLastElement().getValue();
        ServiceName hostServiceName = UndertowService.virtualHostName(serverName, hostName);
        ServiceName serviceName = UndertowService.locationServiceName(serverName, hostName, name);
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName, (Service)service).addDependency(hostServiceName, Host.class, service.getHost()).addDependency(UndertowService.HANDLER.append(new String[]{handler}), HttpHandler.class, service.getHttpHandler());
        LocationAdd.configureFilterRef(fullModel, (ServiceBuilder<LocationService>)builder, service, address);
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static void configureFilterRef(ModelNode model, ServiceBuilder<LocationService> builder, LocationService service, PathAddress address) {
        if (model.hasDefined("filter-ref")) {
            for (Property property : model.get("filter-ref").asPropertyList()) {
                String name = property.getName();
                LocationAdd.addDep(builder, UndertowService.getFilterRefServiceName(address, name), FilterRef.class, service.getFilters());
            }
        }
    }
}

