/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import java.security.PublicKey;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.criteria.PublicKeyCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluablePublicKeyCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluablePublicKeyCredentialCriteria.class);
    private PublicKey publicKey;

    public EvaluablePublicKeyCredentialCriteria(PublicKeyCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.publicKey = criteria.getPublicKey();
    }

    public EvaluablePublicKeyCredentialCriteria(PublicKey newPublicKey) {
        if (newPublicKey == null) {
            throw new IllegalArgumentException("Public key may not be null");
        }
        this.publicKey = newPublicKey;
    }

    @Override
    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        PublicKey key = target.getPublicKey();
        if (key == null) {
            this.log.info("Credential contained no public key, does not satisfy public key criteria");
            return Boolean.FALSE;
        }
        Boolean result = this.publicKey.equals(key);
        return result;
    }
}

