/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.configuration;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.common.configuration.AbstractCommonConfigResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

public class BasicConfigResolver
extends AbstractCommonConfigResolver {
    private final UnifiedVirtualFile deploymentRoot;
    private final Class<?> implementorClass;
    private final String configNameOverride;
    private final String configFileOverride;
    private final EndpointConfig ann;

    public BasicConfigResolver(ArchiveDeployment dep, Class<?> implementorClass) {
        String epConfigName = null;
        String epConfigFile = null;
        JSEArchiveMetaData jsemd = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
        JBossWebservicesMetaData wsmd = (JBossWebservicesMetaData)dep.getAttachment(JBossWebservicesMetaData.class);
        if (jsemd != null) {
            epConfigName = jsemd.getConfigName();
            epConfigFile = jsemd.getConfigFile();
        } else if (wsmd != null) {
            epConfigName = wsmd.getConfigName();
            epConfigFile = wsmd.getConfigFile();
        }
        this.configNameOverride = epConfigName;
        this.configFileOverride = epConfigFile;
        this.implementorClass = implementorClass;
        this.deploymentRoot = dep.getRootFile();
        this.ann = implementorClass.getAnnotation(EndpointConfig.class);
    }

    @Override
    protected URL getDefaultConfigFile(String defaultConfigFileName) {
        UnifiedVirtualFile vf;
        URL url = this.implementorClass.getResource("/" + defaultConfigFileName);
        if (url == null && (vf = this.deploymentRoot.findChildFailSafe(defaultConfigFileName)) != null) {
            url = vf.toURL();
        }
        return url;
    }

    @Override
    protected URL getConfigFile(String configFileName) throws IOException {
        UnifiedVirtualFile vf = this.deploymentRoot.findChild(configFileName);
        return vf.toURL();
    }

    @Override
    protected String getEndpointClassName() {
        return this.implementorClass.getName();
    }

    @Override
    protected <T extends Annotation> boolean isEndpointClassAnnotated(Class<T> annotation) {
        return this.ann != null;
    }

    @Override
    protected String getEndpointConfigNameFromAnnotation() {
        return this.ann.configName();
    }

    @Override
    protected String getEndpointConfigFileFromAnnotation() {
        return this.ann.configFile();
    }

    @Override
    protected String getEndpointConfigNameOverride() {
        return this.configNameOverride;
    }

    @Override
    protected String getEndpointConfigFileOverride() {
        return this.configFileOverride;
    }
}

