/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.metamodel.source.annotations.EnumConversionHelper;
import org.hibernate.metamodel.source.annotations.attribute.AssociationAttribute;
import org.hibernate.metamodel.source.annotations.attribute.SingularAttributeSourceImpl;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.ToOneAttributeSource;

public class ToOneAttributeSourceImpl
extends SingularAttributeSourceImpl
implements ToOneAttributeSource {
    private final AssociationAttribute associationAttribute;
    private final Set<CascadeStyle> cascadeStyles;

    public ToOneAttributeSourceImpl(AssociationAttribute associationAttribute) {
        super(associationAttribute);
        this.associationAttribute = associationAttribute;
        this.cascadeStyles = EnumConversionHelper.cascadeTypeToCascadeStyleSet(associationAttribute.getCascadeTypes());
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.MANY_TO_ONE;
    }

    @Override
    public String getReferencedEntityName() {
        return this.associationAttribute.getReferencedEntityType();
    }

    @Override
    public String getReferencedEntityAttributeName() {
        return this.associationAttribute.getMappedBy();
    }

    @Override
    public Iterable<CascadeStyle> getCascadeStyles() {
        return this.cascadeStyles;
    }

    @Override
    public FetchMode getFetchMode() {
        return this.associationAttribute.getFetchMode();
    }

    @Override
    public FetchTiming getFetchTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public FetchStyle getFetchStyle() {
        return FetchStyle.JOIN;
    }
}

