/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ExternalContextObjectFactory;
import org.jboss.as.naming.ImmediateManagedReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.context.external.ExternalContexts;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.ExternalContextBinderService;
import org.jboss.as.naming.service.ExternalContextsService;
import org.jboss.as.naming.subsystem.BindingType;
import org.jboss.as.naming.subsystem.NamingBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.security.manager.WildFlySecurityManager;

public class NamingBindingAdd
extends AbstractAddStepHandler {
    private static final String[] GLOBAL_NAMESPACES = new String[]{"java:global", "java:jboss", "java:/"};
    static final NamingBindingAdd INSTANCE = new NamingBindingAdd();

    private NamingBindingAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        this.installRuntimeServices(context, name, model);
    }

    void installRuntimeServices(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        boolean allowed = false;
        for (String ns : GLOBAL_NAMESPACES) {
            if (!name.startsWith(ns)) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            throw NamingLogger.ROOT_LOGGER.invalidNamespaceForBinding(name, Arrays.toString(GLOBAL_NAMESPACES));
        }
        BindingType type = BindingType.forName(NamingBindingResourceDefinition.BINDING_TYPE.resolveModelAttribute(context, model).asString());
        if (type == BindingType.SIMPLE) {
            this.installSimpleBinding(context, name, model);
        } else if (type == BindingType.OBJECT_FACTORY) {
            this.installObjectFactory(context, name, model);
        } else if (type == BindingType.LOOKUP) {
            this.installLookup(context, name, model);
        } else if (type == BindingType.EXTERNAL_CONTEXT) {
            this.installExternalContext(context, name, model);
        } else {
            throw NamingLogger.ROOT_LOGGER.unknownBindingType(type.toString());
        }
    }

    void installSimpleBinding(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String value = NamingBindingResourceDefinition.VALUE.resolveModelAttribute(context, model).asString();
        String type = model.hasDefined("type") ? NamingBindingResourceDefinition.TYPE.resolveModelAttribute(context, model).asString() : null;
        Object bindValue = this.coerceToType(value, type);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        BinderService binderService = new BinderService(name, bindValue);
        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value<?>)new ImmediateValue(bindValue)));
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        builder.install();
    }

    void installObjectFactory(OperationContext context, final String name, ModelNode model) throws OperationFailedException {
        ObjectFactory objectFactoryClassInstance;
        Module module;
        ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)NamingBindingResourceDefinition.MODULE.resolveModelAttribute(context, model).asString());
        String className = NamingBindingResourceDefinition.CLASS.resolveModelAttribute(context, model).asString();
        try {
            module = Module.getBootModuleLoader().loadModule(moduleID);
        }
        catch (ModuleLoadException e) {
            throw NamingLogger.ROOT_LOGGER.couldNotLoadModule(moduleID);
        }
        ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            Class clazz = module.getClassLoader().loadClass(className);
            objectFactoryClassInstance = (ObjectFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw NamingLogger.ROOT_LOGGER.couldNotLoadClassFromModule(className, moduleID);
        }
        catch (InstantiationException e) {
            throw NamingLogger.ROOT_LOGGER.couldNotInstantiateClassInstanceFromModule(className, moduleID);
        }
        catch (IllegalAccessException e) {
            throw NamingLogger.ROOT_LOGGER.couldNotInstantiateClassInstanceFromModule(className, moduleID);
        }
        catch (ClassCastException e) {
            throw NamingLogger.ROOT_LOGGER.notAnInstanceOfObjectFactory(className, moduleID);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        final Hashtable<String, String> environment = this.getObjectFactoryEnvironment(context, model);
        BinderService binderService = new BinderService(name, objectFactoryClassInstance);
        binderService.getManagedObjectInjector().inject((Object)new ContextListAndJndiViewManagedReferenceFactory(){

            @Override
            public ManagedReference getReference() {
                try {
                    Object value = objectFactoryClassInstance.getObjectInstance(name, null, null, environment);
                    return new ImmediateManagedReference(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getInstanceClassName() {
                ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)objectFactoryClassInstance.getClass().getClassLoader());
                    Object value = this.getReference().getInstance();
                    String string = value != null ? value.getClass().getName() : ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
                    return string;
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getJndiViewInstanceValue() {
                ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)objectFactoryClassInstance.getClass().getClassLoader());
                    String string = String.valueOf(this.getReference().getInstance());
                    return string;
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
                }
            }
        });
        serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).install();
    }

    void installExternalContext(OperationContext context, final String name, ModelNode model) throws OperationFailedException {
        String moduleID = NamingBindingResourceDefinition.MODULE.resolveModelAttribute(context, model).asString();
        final String className = NamingBindingResourceDefinition.CLASS.resolveModelAttribute(context, model).asString();
        ModelNode cacheNode = NamingBindingResourceDefinition.CACHE.resolveModelAttribute(context, model);
        boolean cache = cacheNode.isDefined() ? cacheNode.asBoolean() : false;
        final ExternalContextObjectFactory objectFactoryClassInstance = new ExternalContextObjectFactory();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        final Hashtable<String, String> environment = this.getObjectFactoryEnvironment(context, model);
        environment.put("cache-context", Boolean.toString(cache));
        environment.put("initial-context-class", className);
        environment.put("initial-context-module", moduleID);
        ExternalContextBinderService binderService = new ExternalContextBinderService(name, objectFactoryClassInstance);
        binderService.getManagedObjectInjector().inject((Object)new ContextListAndJndiViewManagedReferenceFactory(){

            @Override
            public ManagedReference getReference() {
                try {
                    Object value = objectFactoryClassInstance.getObjectInstance(name, null, null, environment);
                    return new ImmediateManagedReference(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String getInstanceClassName() {
                return className;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getJndiViewInstanceValue() {
                ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)objectFactoryClassInstance.getClass().getClassLoader());
                    String string = String.valueOf(this.getReference().getInstance());
                    return string;
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
                }
            }
        });
        serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addDependency(ExternalContextsService.SERVICE_NAME, ExternalContexts.class, binderService.getExternalContextsInjector()).install();
    }

    private Hashtable<String, String> getObjectFactoryEnvironment(OperationContext context, ModelNode model) throws OperationFailedException {
        Map resolvedModelAttribute = NamingBindingResourceDefinition.ENVIRONMENT.unwrap((ExpressionResolver)context, model);
        Hashtable<String, String> environment = new Hashtable<String, String>(resolvedModelAttribute);
        return environment;
    }

    void installLookup(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        final String lookup = NamingBindingResourceDefinition.LOOKUP.resolveModelAttribute(context, model).asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
        BinderService binderService = new BinderService(name);
        binderService.getManagedObjectInjector().inject((Object)new ContextListAndJndiViewManagedReferenceFactory(){

            @Override
            public ManagedReference getReference() {
                try {
                    Object value = new InitialContext().lookup(lookup);
                    return new ImmediateManagedReference(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String getInstanceClassName() {
                Object value = this.getReference().getInstance();
                return value != null ? value.getClass().getName() : ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
            }

            @Override
            public String getJndiViewInstanceValue() {
                return String.valueOf(this.getReference().getInstance());
            }
        });
        serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).install();
    }

    private Object coerceToType(String value, String type) throws OperationFailedException {
        if (type == null || type.isEmpty() || type.equals(String.class.getName())) {
            return value;
        }
        if (type.equals("char") || type.equals("java.lang.Character")) {
            return Character.valueOf(value.charAt(0));
        }
        if (type.equals("byte") || type.equals("java.lang.Byte")) {
            return Byte.parseByte(value);
        }
        if (type.equals("short") || type.equals("java.lang.Short")) {
            return Short.parseShort(value);
        }
        if (type.equals("int") || type.equals("java.lang.Integer")) {
            return Integer.parseInt(value);
        }
        if (type.equals("long") || type.equals("java.lang.Long")) {
            return Long.parseLong(value);
        }
        if (type.equals("float") || type.equals("java.lang.Float")) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals("double") || type.equals("java.lang.Double")) {
            return Double.parseDouble(value);
        }
        if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals(URL.class.getName())) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw NamingLogger.ROOT_LOGGER.unableToTransformURLBindingValue(value, e);
            }
        }
        throw NamingLogger.ROOT_LOGGER.unsupportedSimpleBindingType(type);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : NamingBindingResourceDefinition.ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
        NamingBindingResourceDefinition.validateResourceModel(model);
    }
}

