/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.rest;

import java.io.InputStream;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.STSType;
import org.picketlink.identity.federation.bindings.wildfly.providers.OAuth2TokenProvider;
import org.picketlink.identity.federation.bindings.wildfly.providers.OAuthProtocolContext;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.sts.STSCoreConfig;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.BaseIDAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;

public class STSEndpoint {
    protected String subjectConfirmationMethod = JBossSAMLURIConstants.SUBJECT_CONFIRMATION_BEARER.get();
    protected static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    protected static final String GRANT_TYPE_PARAMETER = "grant_type";
    protected static final String ASSERTION_PARAMETER = "assertion";
    @Context
    protected ServletContext servletContext;
    @Context
    protected ServletConfig servletConfig;
    protected String issuer = null;
    protected PicketLinkCoreSTS sts = null;

    @PostConstruct
    public void initialize() {
        if (this.servletConfig != null) {
            this.issuer = this.servletConfig.getInitParameter("issuer");
            if (this.issuer == null) {
                this.issuer = "PicketLink_SAML_REST";
            }
        }
        this.checkAndSetUpSTS();
    }

    protected void checkAndSetUpSTS() {
        if (this.sts == null) {
            if (this.servletContext != null) {
                this.sts = (PicketLinkCoreSTS)this.servletContext.getAttribute("STS");
            }
            if (this.sts == null) {
                this.sts = PicketLinkCoreSTS.instance();
                try {
                    this.loadConfiguration();
                }
                catch (ParsingException e) {
                    throw new RuntimeException(e);
                }
                if (this.servletContext != null) {
                    this.servletContext.setAttribute("STS", (Object)this.sts);
                }
            }
        }
    }

    protected SAMLProtocolContext getSAMLProtocolContext(String userName) throws ConfigurationException {
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        SubjectType subjectType = new SubjectType();
        NameIDType nameIDType = new NameIDType();
        nameIDType.setFormat(URI.create(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get()));
        nameIDType.setValue(userName);
        SubjectType.STSubType subType = new SubjectType.STSubType();
        subType.addBaseID((BaseIDAbstractType)nameIDType);
        subjectType.setSubType(subType);
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setMethod(this.subjectConfirmationMethod);
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo("REST_REQUEST");
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectType.addConfirmation(subjectConfirmation);
        SAMLProtocolContext samlProtocolContext = new SAMLProtocolContext();
        samlProtocolContext.setSubjectType(subjectType);
        NameIDType issuerNameIDType = new NameIDType();
        issuerNameIDType.setValue(this.issuer);
        samlProtocolContext.setIssuerID(issuerNameIDType);
        return samlProtocolContext;
    }

    protected AssertionType parseAssertion(String base64EncodedAssertion) throws ParsingException {
        InputStream inputStream = PostBindingUtil.base64DecodeAsStream((String)base64EncodedAssertion);
        SAMLParser samlParser = new SAMLParser();
        return (AssertionType)samlParser.parse(inputStream);
    }

    protected AssertionType issueSAMLAssertion(SAMLProtocolContext samlProtocolContext) throws ProcessingException {
        this.checkAndSetUpSTS();
        this.sts.issueToken((ProtocolContext)samlProtocolContext);
        return samlProtocolContext.getIssuedAssertion();
    }

    protected String issueOAuthToken(String assertionID) throws ProcessingException {
        this.checkAndSetUpSTS();
        OAuthProtocolContext oAuthProtocolContext = new OAuthProtocolContext();
        oAuthProtocolContext.setSamlAssertionID(assertionID);
        this.sts.issueToken((ProtocolContext)oAuthProtocolContext);
        return oAuthProtocolContext.getToken();
    }

    public boolean validate(SAMLProtocolContext samlProtocolContext) {
        try {
            this.checkAndSetUpSTS();
            this.sts.validateToken((ProtocolContext)samlProtocolContext);
            return true;
        }
        catch (ProcessingException pe) {
            return false;
        }
    }

    protected void loadConfiguration() throws ParsingException {
        InputStream inputStream = null;
        if (this.servletContext != null) {
            inputStream = this.servletContext.getResourceAsStream("/WEB-INF/picketlink.xml");
        }
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream("picketlink.xml");
        }
        if (inputStream != null) {
            PicketLinkType picketLinkConfiguration = ConfigurationUtil.getConfiguration((InputStream)inputStream);
            STSType stsType = picketLinkConfiguration.getStsType();
            if (stsType != null) {
                this.sts.initialize((STSCoreConfig)new PicketLinkSTSConfiguration(stsType));
            }
        } else {
            this.sts.installDefaultConfiguration(new String[0]);
            try {
                this.sts.getConfiguration().addTokenProvider("urn:oauth:2:0", (SecurityTokenProvider)OAuth2TokenProvider.class.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

