/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.AckCollector;
import org.jgroups.util.Bits;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class MPerf
extends ReceiverAdapter {
    protected String props;
    protected JChannel channel;
    protected final AckCollector ack_collector = new AckCollector();
    protected Address local_addr = null;
    protected String name;
    protected int num_msgs = 1000000;
    protected int msg_size = 1000;
    protected int num_threads = 10;
    protected int log_interval = this.num_msgs / 10;
    protected int receive_log_interval = Math.max(1, this.num_msgs / 10);
    protected int num_senders = -1;
    protected boolean oob = false;
    protected boolean cancelled = false;
    protected final ConcurrentMap<Address, Stats> received_msgs = Util.createConcurrentMap();
    protected final AtomicLong total_received_msgs = new AtomicLong(0L);
    protected final List<Address> members = new CopyOnWriteArrayList<Address>();
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean looping = true;
    protected long last_interval = 0L;
    protected final ResponseCollector<Result> results = new ResponseCollector();
    protected volatile Address result_collector = null;
    protected volatile boolean initiator = false;
    protected static final NumberFormat format = NumberFormat.getNumberInstance();
    protected static final short ID = ClassConfigurator.getProtocolId(MPerf.class);

    public void start(String props, String name) throws Exception {
        this.props = props;
        this.name = name;
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n----------------------- MPerf -----------------------\n");
        sb.append("Date: ").append(new Date()).append('\n');
        sb.append("Run by: ").append(System.getProperty("user.name")).append("\n");
        sb.append("JGroups version: ").append("3.6.2.Final").append('\n');
        System.out.println(sb);
        this.channel = new JChannel(props);
        this.channel.setName(name);
        this.channel.setReceiver(this);
        this.channel.connect("mperf");
        this.local_addr = this.channel.getAddress();
        JmxConfigurator.registerChannel(this.channel, Util.getMBeanServer(), "jgroups", "mperf", true);
        Address coord = this.channel.getView().getMembers().get(0);
        if (coord != null && !this.local_addr.equals(coord)) {
            this.send(coord, null, (byte)7, Message.Flag.RSVP);
        }
    }

    protected void loop() {
        String INPUT = "[1] Send [2] View\n[3] Set num msgs (%d) [4] Set msg size (%s) [5] Set threads (%d) [6] New config (%s)\n[7] Number of senders (%s) [o] Toggle OOB (%s)\n[x] Exit this [X] Exit all [c] Cancel sending";
        while (this.looping) {
            try {
                int c = Util.keyPress(String.format("[1] Send [2] View\n[3] Set num msgs (%d) [4] Set msg size (%s) [5] Set threads (%d) [6] New config (%s)\n[7] Number of senders (%s) [o] Toggle OOB (%s)\n[x] Exit this [X] Exit all [c] Cancel sending", this.num_msgs, Util.printBytes(this.msg_size), this.num_threads, this.props == null ? "<default>" : this.props, this.num_senders <= 0 ? "all" : String.valueOf(this.num_senders), this.oob));
                switch (c) {
                    case 49: {
                        this.cancelled = false;
                        this.initiator = true;
                        this.results.reset(this.getSenders());
                        this.ack_collector.reset(this.channel.getView().getMembers());
                        this.send(null, null, (byte)5, Message.Flag.RSVP);
                        this.ack_collector.waitForAllAcks(5000L);
                        this.send(null, null, (byte)2, Message.Flag.RSVP);
                        break;
                    }
                    case 50: {
                        System.out.println("view: " + this.channel.getView() + " (local address=" + this.channel.getAddress() + ")");
                        break;
                    }
                    case 51: {
                        this.configChange("num_msgs");
                        break;
                    }
                    case 52: {
                        this.configChange("msg_size");
                        break;
                    }
                    case 53: {
                        this.configChange("num_threads");
                        break;
                    }
                    case 54: {
                        this.newConfig();
                        break;
                    }
                    case 55: {
                        this.configChange("num_senders");
                        break;
                    }
                    case 111: {
                        ConfigChange change = new ConfigChange("oob", !this.oob);
                        this.send(null, change, (byte)6, Message.Flag.RSVP);
                        break;
                    }
                    case 120: {
                        this.looping = false;
                        break;
                    }
                    case 88: {
                        this.send(null, null, (byte)9, new Message.Flag[0]);
                        break;
                    }
                    case 99: {
                        this.cancelled = true;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.stop();
    }

    protected void displayResults() {
        System.out.println("\nResults:\n");
        Map<Address, Result> tmp_results = this.results.getResults();
        for (Map.Entry<Address, Result> entry : tmp_results.entrySet()) {
            Result val = entry.getValue();
            if (val == null) continue;
            System.out.println(entry.getKey() + ": " + MPerf.computeStats(val.time, val.msgs, this.msg_size));
        }
        long total_msgs = 0L;
        long total_time = 0L;
        long num = 0L;
        for (Result result : tmp_results.values()) {
            if (result == null) continue;
            total_time += result.time;
            total_msgs += result.msgs;
            ++num;
        }
        if (num > 0L) {
            System.out.println("\n===============================================================================");
            System.out.println("\u001b[1m Average/node:    " + MPerf.computeStats(total_time / num, total_msgs / num, this.msg_size));
            System.out.println("\u001b[0m Average/cluster: " + MPerf.computeStats(total_time / num, total_msgs, this.msg_size));
            System.out.println("================================================================================\n\n");
        } else {
            System.out.println("\n===============================================================================");
            System.out.println("\u001b[1m Received no results");
            System.out.println("\u001b[0m");
            System.out.println("================================================================================\n\n");
        }
    }

    protected void configChange(String name) throws Exception {
        int tmp = Util.readIntFromStdin(name + ": ");
        ConfigChange change = new ConfigChange(name, tmp);
        this.send(null, change, (byte)6, Message.Flag.RSVP);
    }

    protected void newConfig() throws Exception {
        String filename = Util.readStringFromStdin("Config file: ");
        InputStream input = MPerf.findFile(filename);
        byte[] contents = Util.readFileContents(input);
        this.send(null, contents, (byte)10, new Message.Flag[0]);
        ConfigChange change = new ConfigChange("props", filename);
        this.send(null, change, (byte)6, Message.Flag.RSVP);
    }

    protected void send(Address target, Object payload, byte header, Message.Flag ... flags) throws Exception {
        Message msg = new Message(target, null, payload);
        if (flags != null) {
            for (Message.Flag flag : flags) {
                msg.setFlag(flag);
            }
        }
        if (header > 0) {
            msg.putHeader(ID, new MPerfHeader(header));
        }
        this.channel.send(msg);
    }

    protected static String printProperties() {
        StringBuilder sb = new StringBuilder();
        Properties p = System.getProperties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    protected static InputStream findFile(String filename) {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            File file = new File(filename);
            String name = file.getName();
            try {
                return new FileInputStream(name);
            }
            catch (FileNotFoundException e2) {
                try {
                    String home_dir = System.getProperty("user.home");
                    filename = home_dir + File.separator + name;
                    try {
                        return new FileInputStream(filename);
                    }
                    catch (FileNotFoundException e3) {
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return Util.getResourceAsStream(name, MPerf.class);
            }
        }
    }

    public void stop() {
        this.looping = false;
        try {
            JmxConfigurator.unregisterChannel(this.channel, Util.getMBeanServer(), "jgroups", "mperf");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Util.close((Closeable)this.channel);
    }

    @Override
    public void receive(Message msg) {
        MPerfHeader hdr = (MPerfHeader)msg.getHeader(ID);
        switch (hdr.type) {
            case 1: {
                this.handleData(msg.getSrc(), hdr.seqno, this.num_threads == 1 && !this.oob);
                break;
            }
            case 2: {
                int my_rank;
                if (this.num_senders > 0 && (my_rank = Util.getRank(this.members, this.local_addr)) >= 0 && my_rank > this.num_senders) break;
                this.result_collector = msg.getSrc();
                this.sendMessages();
                break;
            }
            case 3: {
                Address sender = msg.getSrc();
                Stats tmp = (Stats)this.received_msgs.get(sender);
                if (tmp != null) {
                    tmp.stop();
                }
                boolean all_done = true;
                List<Address> senders = this.getSenders();
                for (Map.Entry entry : this.received_msgs.entrySet()) {
                    Address mbr = (Address)entry.getKey();
                    Stats result = (Stats)entry.getValue();
                    if (!senders.contains(mbr) || result.isDone()) continue;
                    all_done = false;
                    break;
                }
                if (!all_done || this.result_collector == null) break;
                long start = 0L;
                long stop = 0L;
                long msgs = 0L;
                for (Stats result : this.received_msgs.values()) {
                    if (result.start > 0L) {
                        long l = start = start == 0L ? result.start : Math.min(start, result.start);
                    }
                    if (result.stop > 0L) {
                        stop = stop == 0L ? result.stop : Math.max(stop, result.stop);
                    }
                    msgs += result.num_msgs_received;
                }
                Result result = new Result(stop - start, msgs);
                try {
                    if (this.result_collector == null) break;
                    this.send(this.result_collector, result, (byte)4, Message.Flag.RSVP);
                }
                catch (Exception e) {
                    System.err.println("failed sending results to " + this.result_collector + ": " + e);
                }
                break;
            }
            case 4: {
                Result res = (Result)msg.getObject();
                this.results.add(msg.getSrc(), res);
                if (!this.initiator || !this.results.hasAllResponses()) break;
                this.initiator = false;
                this.displayResults();
                break;
            }
            case 5: {
                for (Stats result : this.received_msgs.values()) {
                    result.reset();
                }
                this.total_received_msgs.set(0L);
                this.last_interval = 0L;
                try {
                    this.send(msg.getSrc(), null, (byte)11, Message.Flag.OOB);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                ConfigChange config_change = (ConfigChange)msg.getObject();
                this.handleConfigChange(config_change);
                break;
            }
            case 7: {
                try {
                    this.handleConfigRequest(msg.getSrc());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                this.handleConfigResponse((Configuration)msg.getObject());
                break;
            }
            case 9: {
                ProtocolStack stack = this.channel.getProtocolStack();
                String cluster_name = this.channel.getClusterName();
                try {
                    JmxConfigurator.unregisterChannel(this.channel, Util.getMBeanServer(), "jgroups", "mperf");
                }
                catch (Exception e) {
                    // empty catch block
                }
                stack.stopStack(cluster_name);
                stack.destroy();
                break;
            }
            case 10: {
                this.applyNewConfig(msg.getBuffer());
                break;
            }
            case 11: {
                this.ack_collector.ack(msg.getSrc());
                break;
            }
            default: {
                System.err.println("Header type " + hdr.type + " not recognized");
            }
        }
    }

    protected void handleData(Address src, long seqno, boolean check_order) {
        long received_so_far;
        Stats tmp;
        Stats result = (Stats)this.received_msgs.get(src);
        if (result == null && (tmp = this.received_msgs.putIfAbsent(src, result = new Stats())) != null) {
            result = tmp;
        }
        result.addMessage(seqno, check_order);
        if (this.last_interval == 0L) {
            this.last_interval = System.currentTimeMillis();
        }
        if ((received_so_far = this.total_received_msgs.incrementAndGet()) % (long)this.receive_log_interval == 0L) {
            long curr_time = System.currentTimeMillis();
            long diff = curr_time - this.last_interval;
            double msgs_sec = (double)this.receive_log_interval / ((double)diff / 1000.0);
            double throughput = msgs_sec * (double)this.msg_size;
            this.last_interval = curr_time;
            System.out.println("-- received " + received_so_far + " msgs " + "(" + diff + " ms, " + format.format(msgs_sec) + " msgs/sec, " + Util.printBytes(throughput) + "/sec)");
        }
    }

    protected List<Address> getSenders() {
        if (this.num_senders <= 0) {
            return new ArrayList<Address>(this.members);
        }
        ArrayList<Address> retval = new ArrayList<Address>();
        for (int i = 0; i < this.num_senders; ++i) {
            retval.add(this.members.get(i));
        }
        return retval;
    }

    protected void applyNewConfig(byte[] buffer) {
        final ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JChannel ch = new JChannel(in);
                    Util.sleepRandom(1000L, 5000L);
                    MPerf.this.channel.disconnect();
                    JChannel tmp = MPerf.this.channel;
                    MPerf.this.channel = ch;
                    MPerf.this.channel.setName(MPerf.this.name);
                    MPerf.this.channel.setReceiver(MPerf.this);
                    MPerf.this.channel.connect("mperf");
                    MPerf.this.local_addr = MPerf.this.channel.getAddress();
                    JmxConfigurator.unregisterChannel(tmp, Util.getMBeanServer(), "jgroups", "mperf");
                    Util.close((Closeable)tmp);
                    JmxConfigurator.registerChannel(MPerf.this.channel, Util.getMBeanServer(), "jgroups", "mperf", true);
                }
                catch (Exception e) {
                    System.err.println("failed creating new channel");
                }
            }
        };
        System.out.println("<< restarting channel");
        thread.start();
    }

    protected void handleConfigChange(ConfigChange config_change) {
        String attr_name = config_change.attr_name;
        try {
            Object attr_value = config_change.getValue();
            Field field = Util.getField(this.getClass(), attr_name);
            Util.setField(field, this, attr_value);
            System.out.println(config_change.attr_name + "=" + attr_value);
            this.log_interval = this.num_msgs / 10;
            this.receive_log_interval = Math.max(1, this.num_msgs * Math.max(1, this.members.size()) / 10);
        }
        catch (Exception e) {
            System.err.println("failed applying config change for attr " + attr_name + ": " + e);
        }
    }

    protected void handleConfigRequest(Address sender) throws Exception {
        Configuration cfg = new Configuration();
        cfg.addChange("num_msgs", this.num_msgs);
        cfg.addChange("msg_size", this.msg_size);
        cfg.addChange("num_threads", this.num_threads);
        cfg.addChange("num_senders", this.num_senders);
        cfg.addChange("oob", this.oob);
        this.send(sender, cfg, (byte)8, new Message.Flag[0]);
    }

    protected void handleConfigResponse(Configuration cfg) {
        for (ConfigChange change : cfg.changes) {
            this.handleConfigChange(change);
        }
    }

    @Override
    public void viewAccepted(View view) {
        System.out.println("** " + view);
        List<Address> mbrs = view.getMembers();
        this.members.clear();
        this.members.addAll(mbrs);
        this.receive_log_interval = Math.max(1, this.num_msgs * mbrs.size() / 10);
        this.received_msgs.keySet().retainAll(mbrs);
        for (Address member : mbrs) {
            this.received_msgs.putIfAbsent(member, new Stats());
        }
        this.results.retainAll(mbrs);
        if (this.result_collector != null && !mbrs.contains(this.result_collector)) {
            this.result_collector = null;
        }
    }

    protected void sendMessages() {
        AtomicInteger num_msgs_sent = new AtomicInteger(0);
        AtomicInteger actually_sent = new AtomicInteger(0);
        AtomicLong seqno = new AtomicLong(1L);
        Sender[] senders = new Sender[this.num_threads];
        CyclicBarrier barrier = new CyclicBarrier(this.num_threads + 1);
        byte[] payload = new byte[this.msg_size];
        for (int i = 0; i < this.num_threads; ++i) {
            senders[i] = new Sender(barrier, num_msgs_sent, actually_sent, seqno, payload);
            senders[i].setName("sender-" + i);
            senders[i].start();
        }
        try {
            System.out.println("-- sending " + this.num_msgs + (this.oob ? " OOB msgs" : " msgs"));
            barrier.await();
        }
        catch (Exception e) {
            System.err.println("failed triggering send threads: " + e);
        }
    }

    protected static String computeStats(long time, long msgs, int size) {
        StringBuilder sb = new StringBuilder();
        double throughput = 0.0;
        double msgs_sec = (double)msgs / ((double)time / 1000.0);
        throughput = (double)(msgs * (long)size) / ((double)time / 1000.0);
        sb.append(msgs).append(" msgs, ");
        sb.append(Util.printBytes(msgs * (long)size)).append(" received");
        sb.append(", time=").append(format.format(time)).append("ms");
        sb.append(", msgs/sec=").append(format.format(msgs_sec));
        sb.append(", throughput=").append(Util.printBytes(throughput));
        return sb.toString();
    }

    public static void main(String[] args) {
        String props = null;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            System.out.println("MPerf [-props <stack config>] [-name <logical name>]");
            return;
        }
        final MPerf test = new MPerf();
        try {
            test.start(props, name);
            Thread thread = new Thread("MPerf runner"){

                @Override
                public void run() {
                    test.loop();
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(2);
    }

    protected static class MPerfHeader
    extends Header {
        protected static final byte DATA = 1;
        protected static final byte START_SENDING = 2;
        protected static final byte SENDING_DONE = 3;
        protected static final byte RESULT = 4;
        protected static final byte CLEAR_RESULTS = 5;
        protected static final byte CONFIG_CHANGE = 6;
        protected static final byte CONFIG_REQ = 7;
        protected static final byte CONFIG_RSP = 8;
        protected static final byte EXIT = 9;
        protected static final byte NEW_CONFIG = 10;
        protected static final byte ACK = 11;
        protected byte type;
        protected long seqno;

        public MPerfHeader() {
        }

        public MPerfHeader(byte type) {
            this.type = type;
        }

        public MPerfHeader(byte type, long seqno) {
            this(type);
            this.seqno = seqno;
        }

        @Override
        public int size() {
            int retval = 1;
            if (this.type == 1) {
                retval += Bits.size(this.seqno);
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            if (this.type == 1) {
                Bits.writeLong(this.seqno, out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            if (this.type == 1) {
                this.seqno = Bits.readLong(in);
            }
        }

        @Override
        public String toString() {
            return MPerfHeader.typeToString(this.type) + " " + (this.seqno > 0L ? Long.valueOf(this.seqno) : "");
        }

        protected static String typeToString(byte type) {
            switch (type) {
                case 1: {
                    return "DATA";
                }
                case 2: {
                    return "START_SENDING";
                }
                case 3: {
                    return "SENDING_DONE";
                }
                case 4: {
                    return "RESULT";
                }
                case 5: {
                    return "CLEAR_RESULTS";
                }
                case 6: {
                    return "CONFIG_CHANGE";
                }
                case 7: {
                    return "CONFIG_REQ";
                }
                case 8: {
                    return "CONFIG_RSP";
                }
                case 9: {
                    return "EXIT";
                }
                case 10: {
                    return "NEW_CONFIG";
                }
                case 11: {
                    return "ACK";
                }
            }
            return "n/a";
        }
    }

    protected static class Result
    implements Streamable {
        protected long time = 0L;
        protected long msgs = 0L;

        public Result() {
        }

        public Result(long time, long msgs) {
            this.time = time;
            this.msgs = msgs;
        }

        public int size() {
            return Bits.size(this.time) + Bits.size(this.msgs);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            Bits.writeLong(this.time, out);
            Bits.writeLong(this.msgs, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.time = Bits.readLong(in);
            this.msgs = Bits.readLong(in);
        }

        public String toString() {
            return this.msgs + " in " + this.time + " ms";
        }
    }

    protected class Stats {
        protected long start = 0L;
        protected long stop = 0L;
        protected long num_msgs_received = 0L;
        protected long seqno = 1L;

        protected Stats() {
        }

        public void reset() {
            this.num_msgs_received = 0L;
            this.stop = 0L;
            this.start = 0L;
            this.seqno = 1L;
        }

        public void stop() {
            this.stop = System.currentTimeMillis();
        }

        public boolean isDone() {
            return this.stop > 0L;
        }

        public void addMessage(long seqno, boolean check_order) {
            if (this.start == 0L) {
                this.start = System.currentTimeMillis();
            }
            if (seqno != this.seqno && check_order) {
                throw new IllegalStateException("expected seqno=" + this.seqno + ", but received " + seqno);
            }
            ++this.seqno;
            ++this.num_msgs_received;
        }

        public String toString() {
            return MPerf.computeStats(this.stop - this.start, this.num_msgs_received, MPerf.this.msg_size);
        }
    }

    protected static class Configuration
    implements Streamable {
        protected List<ConfigChange> changes = new ArrayList<ConfigChange>();

        public Configuration addChange(String key, Object val) throws Exception {
            if (key != null && val != null) {
                this.changes.add(new ConfigChange(key, val));
            }
            return this;
        }

        public int size() {
            int retval = 4;
            for (ConfigChange change : this.changes) {
                retval += change.size();
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeInt(this.changes.size());
            for (ConfigChange change : this.changes) {
                change.writeTo(out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            int len = in.readInt();
            for (int i = 0; i < len; ++i) {
                ConfigChange change = new ConfigChange();
                change.readFrom(in);
                this.changes.add(change);
            }
        }
    }

    protected static class ConfigChange
    implements Streamable {
        protected String attr_name;
        protected byte[] attr_value;

        public ConfigChange() {
        }

        public ConfigChange(String attr_name, Object val) throws Exception {
            this.attr_name = attr_name;
            this.attr_value = Util.objectToByteBuffer(val);
        }

        public Object getValue() throws Exception {
            return Util.objectFromByteBuffer(this.attr_value);
        }

        public int size() {
            return Util.size(this.attr_name) + Util.size(this.attr_value);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            Bits.writeString(this.attr_name, out);
            Util.writeByteBuffer(this.attr_value, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.attr_name = Bits.readString(in);
            this.attr_value = Util.readByteBuffer(in);
        }
    }

    protected class Sender
    extends Thread {
        protected final CyclicBarrier barrier;
        protected final AtomicInteger num_msgs_sent;
        protected final AtomicInteger actually_sent;
        protected final AtomicLong seqno;
        protected final byte[] payload;

        protected Sender(CyclicBarrier barrier, AtomicInteger num_msgs_sent, AtomicInteger actually_sent, AtomicLong seqno, byte[] payload) {
            this.barrier = barrier;
            this.num_msgs_sent = num_msgs_sent;
            this.actually_sent = actually_sent;
            this.seqno = seqno;
            this.payload = payload;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            while (true) {
                try {
                    int tmp;
                    while ((tmp = this.num_msgs_sent.incrementAndGet()) <= MPerf.this.num_msgs && !MPerf.this.cancelled) {
                        long new_seqno = this.seqno.getAndIncrement();
                        Message msg = new Message(null, this.payload).putHeader(ID, new MPerfHeader(1, new_seqno));
                        if (MPerf.this.oob) {
                            msg.setFlag(Message.Flag.OOB);
                        }
                        MPerf.this.channel.send(msg);
                        if (tmp % MPerf.this.log_interval == 0) {
                            System.out.println("++ sent " + tmp);
                        }
                        if ((tmp = this.actually_sent.incrementAndGet()) != MPerf.this.num_msgs) continue;
                        MPerf.this.send(null, null, (byte)3, Message.Flag.RSVP);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

