/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.util.CondVar;
import org.jgroups.util.Condition;

public class ResponseCollector<T>
implements Condition {
    private final Map<Address, T> responses;
    private final Lock lock = new ReentrantLock(false);
    private final CondVar cond = new CondVar(this.lock);

    public ResponseCollector(Collection<Address> members) {
        this.responses = members != null ? new HashMap(members.size()) : new HashMap();
        this.reset(members);
    }

    public ResponseCollector(Address ... members) {
        this.responses = members != null ? new HashMap(members.length) : new HashMap();
        this.reset(members);
    }

    public ResponseCollector() {
        this.responses = new HashMap<Address, T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Address member, T data) {
        if (member == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.responses.containsKey(member)) {
                this.responses.put(member, data);
                this.cond.signal(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Address member) {
        if (member == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.responses.remove(member) != null) {
                this.cond.signal(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(List<Address> members) {
        if (members == null || members.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            for (Address member : members) {
                this.responses.remove(member);
            }
            this.cond.signal(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainAll(List<Address> members) {
        if (members == null || members.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            if (this.responses.keySet().retainAll(members)) {
                this.cond.signal(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void suspect(Address member) {
        this.remove(member);
    }

    @Override
    public boolean isMet() {
        return this.hasAllResponses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAllResponses() {
        this.lock.lock();
        try {
            if (this.responses.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            for (Map.Entry<Address, T> entry : this.responses.entrySet()) {
                if (entry.getValue() != null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfValidResponses() {
        int retval = 0;
        this.lock.lock();
        try {
            for (Map.Entry<Address, T> entry : this.responses.entrySet()) {
                if (entry.getValue() == null) continue;
                ++retval;
            }
            int n = retval;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Address> getMissing() {
        ArrayList<Address> retval = new ArrayList<Address>();
        for (Map.Entry<Address, T> entry : this.responses.entrySet()) {
            if (entry.getValue() != null) continue;
            retval.add(entry.getKey());
        }
        return retval;
    }

    public List<Address> getValidResults() {
        ArrayList<Address> retval = new ArrayList<Address>();
        for (Map.Entry<Address, T> entry : this.responses.entrySet()) {
            if (entry.getValue() == null) continue;
            retval.add(entry.getKey());
        }
        return retval;
    }

    public Map<Address, T> getResults() {
        return this.responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.responses.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean waitForAllResponses(long timeout) {
        if (timeout <= 0L) {
            timeout = 2000L;
        }
        return this.cond.waitFor(this, timeout, TimeUnit.MILLISECONDS);
    }

    public void reset() {
        this.reset((Collection<Address>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Collection<Address> members) {
        this.lock.lock();
        try {
            this.responses.clear();
            if (members != null) {
                for (Address mbr : members) {
                    this.responses.put(mbr, null);
                }
            }
            this.cond.signal(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Address ... members) {
        this.lock.lock();
        try {
            this.responses.clear();
            if (members != null) {
                for (Address mbr : members) {
                    this.responses.put(mbr, null);
                }
            }
            this.cond.signal(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.responses).append(", complete=").append(this.hasAllResponses());
        return sb.toString();
    }
}

