/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;

public class MemoryTokenStore
implements TokenStore {
    public static final long DEFAULT_TTL = 300L;
    public static final long MAX_TTL = 3600L;
    private Map<String, CacheEntry> tokens = new ConcurrentHashMap<String, CacheEntry>();
    private long ttl = 300L;

    @Override
    public void add(SecurityToken token) {
        CacheEntry cacheEntry;
        if (token != null && !StringUtils.isEmpty((String)token.getId()) && (cacheEntry = this.createCacheEntry(token)) != null) {
            this.tokens.put(token.getId(), cacheEntry);
        }
    }

    @Override
    public void add(String identifier, SecurityToken token) {
        CacheEntry cacheEntry;
        if (token != null && !StringUtils.isEmpty((String)identifier) && (cacheEntry = this.createCacheEntry(token)) != null) {
            this.tokens.put(identifier, cacheEntry);
        }
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    @Override
    public void remove(String identifier) {
        if (!StringUtils.isEmpty((String)identifier) && this.tokens.containsKey(identifier)) {
            this.tokens.remove(identifier);
        }
    }

    @Override
    public Collection<String> getTokenIdentifiers() {
        this.processTokenExpiry();
        return this.tokens.keySet();
    }

    @Override
    public SecurityToken getToken(String id) {
        this.processTokenExpiry();
        CacheEntry cacheEntry = this.tokens.get(id);
        if (cacheEntry != null) {
            return cacheEntry.getSecurityToken();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTokenExpiry() {
        Date current = new Date();
        Map<String, CacheEntry> map = this.tokens;
        synchronized (map) {
            for (String id : this.tokens.keySet()) {
                CacheEntry cacheEntry = this.tokens.get(id);
                if (!cacheEntry.getExpiry().before(current)) continue;
                this.tokens.remove(id);
            }
        }
    }

    private CacheEntry createCacheEntry(SecurityToken token) {
        Date expires = new Date();
        long currentTime = expires.getTime();
        expires.setTime(currentTime + this.ttl * 1000L);
        return new CacheEntry(token, expires);
    }

    private static class CacheEntry {
        private final SecurityToken securityToken;
        private final Date expires;

        public CacheEntry(SecurityToken securityToken, Date expires) {
            this.securityToken = securityToken;
            this.expires = expires;
        }

        public SecurityToken getSecurityToken() {
            return this.securityToken;
        }

        public Date getExpiry() {
            return this.expires;
        }
    }
}

