/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.server.Services;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectorDependency;

public class AdvancedCacheConfigurationBuilder
implements Builder<Configuration>,
ConfigurationFactory {
    private static final String DEFAULTS = "infinispan-defaults.xml";
    private static final Map<CacheMode, Configuration> DEFAULT_CONFIGURATIONS = new EnumMap<CacheMode, Configuration>(CacheMode.class);
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
    private final InjectedValue<TransactionManager> tm = new InjectedValue();
    private final InjectedValue<TransactionSynchronizationRegistry> tsr = new InjectedValue();
    private final String containerName;
    private final Builder<Configuration> builder;
    private final CacheMode mode;
    private final ModuleIdentifier module;
    private final ConfigurationBuilder configurationBuilder;
    private final List<Dependency> dependencies = new LinkedList<Dependency>();
    private final List<ServiceName> names = new LinkedList<ServiceName>();
    private ConsistentHashStrategy consistentHashStrategy = ConsistentHashStrategy.DEFAULT;
    private TransactionMode txMode = TransactionMode.DEFAULT;

    public static synchronized Configuration getDefaultConfiguration(CacheMode cacheMode) {
        if (DEFAULT_CONFIGURATIONS.isEmpty()) {
            ConfigurationBuilderHolder holder = AdvancedCacheConfigurationBuilder.load(DEFAULTS);
            Configuration defaultConfig = holder.getDefaultConfigurationBuilder().build();
            DEFAULT_CONFIGURATIONS.put(defaultConfig.clustering().cacheMode(), defaultConfig);
            for (ConfigurationBuilder builder : holder.getNamedConfigurationBuilders().values()) {
                Configuration config = builder.build();
                DEFAULT_CONFIGURATIONS.put(config.clustering().cacheMode(), config);
            }
            for (CacheMode mode : CacheMode.values()) {
                if (DEFAULT_CONFIGURATIONS.containsKey(mode)) continue;
                DEFAULT_CONFIGURATIONS.put(mode, new ConfigurationBuilder().read(defaultConfig).clustering().cacheMode(mode).build());
            }
        }
        return DEFAULT_CONFIGURATIONS.get(cacheMode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ConfigurationBuilderHolder load(String resource) {
        URL url = AdvancedCacheConfigurationBuilder.find(resource, CacheAddHandler.class.getClassLoader());
        ParserRegistry parser = new ParserRegistry(ParserRegistry.class.getClassLoader());
        try (InputStream input = url.openStream();){
            ConfigurationBuilderHolder configurationBuilderHolder = parser.parse(input);
            return configurationBuilderHolder;
        }
        catch (IOException e) {
            throw InfinispanLogger.ROOT_LOGGER.failedToParse(e, url);
        }
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(resource);
    }

    public AdvancedCacheConfigurationBuilder(String containerName, String cacheName, CacheMode mode, ModuleIdentifier module) {
        this.builder = new org.wildfly.clustering.infinispan.spi.service.ConfigurationBuilder(containerName, cacheName, (ConfigurationFactory)this);
        this.containerName = containerName;
        this.configurationBuilder = new ConfigurationBuilder().read(AdvancedCacheConfigurationBuilder.getDefaultConfiguration(mode));
        this.mode = mode;
        this.module = module;
    }

    public ServiceName getServiceName() {
        return this.builder.getServiceName();
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        ServiceBuilder builder = this.builder.build(target).addDependency(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(this.containerName), EmbeddedCacheManager.class, this.container).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).addDependencies(this.names);
        switch (this.txMode) {
            case NONE: {
                break;
            }
            case BATCH: {
                this.tm.inject((Object)DummyTransactionManager.getInstance());
                break;
            }
            case NON_XA: {
                builder.addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, this.tsr);
            }
            default: {
                builder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, this.tm);
            }
        }
        for (Dependency dependency : this.dependencies) {
            dependency.register(builder);
        }
        return builder.setInitialMode(ServiceController.Mode.PASSIVE);
    }

    public Configuration createConfiguration() {
        TransactionSynchronizationRegistry tsr;
        TransactionManager tm;
        EmbeddedCacheManager container = (EmbeddedCacheManager)this.container.getValue();
        this.registerGroupers(container.getCacheManagerConfiguration().classLoader());
        if (this.module != null) {
            try {
                Module module = ((ModuleLoader)this.loader.getValue()).loadModule(this.module);
                this.registerGroupers((ClassLoader)module.getClassLoader());
            }
            catch (ModuleLoadException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if ((tm = (TransactionManager)this.tm.getOptionalValue()) != null) {
            this.configurationBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(tm));
        }
        if ((tsr = (TransactionSynchronizationRegistry)this.tsr.getOptionalValue()) != null) {
            this.configurationBuilder.transaction().transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(tsr));
        }
        boolean topologyAware = container.getCacheManagerConfiguration().transport().hasTopologyInfo();
        this.consistentHashStrategy.buildHashConfiguration(this.configurationBuilder.clustering().hash(), this.mode, topologyAware);
        return this.configurationBuilder.build();
    }

    private void registerGroupers(ClassLoader loader) {
        GroupsConfigurationBuilder groupsBuilder = this.configurationBuilder.clustering().hash().groups();
        for (Grouper grouper : ServiceLoader.load(Grouper.class, loader)) {
            groupsBuilder.addGrouper(grouper);
        }
    }

    public ConfigurationBuilder getConfigurationBuilder() {
        return this.configurationBuilder;
    }

    public AdvancedCacheConfigurationBuilder setConsistentHashStrategy(ConsistentHashStrategy consistentHashStrategy) {
        this.consistentHashStrategy = consistentHashStrategy;
        return this;
    }

    public AdvancedCacheConfigurationBuilder setTransactionMode(TransactionMode txMode) {
        this.txMode = txMode;
        return this;
    }

    public AdvancedCacheConfigurationBuilder addDependency(ServiceName name) {
        this.names.add(name);
        return this;
    }

    public <T> Value<T> addDependency(ServiceName name, Class<T> targetClass) {
        InjectedValue value = new InjectedValue();
        this.dependencies.add((Dependency)new InjectorDependency(name, targetClass, (Injector)value));
        return value;
    }

    public <T> void addDependency(ServiceName name, Class<T> targetClass, Injector<T> injector) {
        this.dependencies.add((Dependency)new InjectorDependency(name, targetClass, injector));
    }
}

