/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class TransportConfigurationBuilder
implements Builder<TransportConfiguration>,
Value<TransportConfiguration>,
TransportConfiguration {
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final InjectedValue<ChannelFactory> factory = new InjectedValue();
    private final String name;
    private long lockTimeout = TransportResourceDefinition.LOCK_TIMEOUT.getDefaultValue().asLong();
    private ValueDependency<Executor> executor = null;

    public TransportConfigurationBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return CacheContainerServiceName.CACHE_CONTAINER.getServiceName(this.name).append(new String[]{"transport"});
    }

    public ServiceBuilder<TransportConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ChannelServiceName.CHANNEL.getServiceName(this.name), Channel.class, this.channel).addDependency(ChannelServiceName.FACTORY.getServiceName(this.name), ChannelFactory.class, this.factory);
        if (this.executor != null) {
            this.executor.register(builder);
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public TransportConfiguration getValue() {
        return this;
    }

    public TransportConfigurationBuilder setLockTimeout(long value, TimeUnit unit) {
        this.lockTimeout = TimeUnit.MILLISECONDS.convert(value, unit);
        return this;
    }

    public TransportConfigurationBuilder setExecutor(String executorName) {
        if (executorName != null) {
            this.executor = new InjectedValueDependency(ThreadsServices.executorName((String)executorName), Executor.class);
        }
        return this;
    }

    @Override
    public long getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    @Override
    public ChannelFactory getChannelFactory() {
        return (ChannelFactory)this.factory.getValue();
    }

    @Override
    public Executor getExecutor() {
        return this.executor != null ? (Executor)this.executor.getValue() : null;
    }
}

