/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.remoting.RemotingConnectionCredential;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class RemotingLoginModule
extends AbstractServerLoginModule {
    private static final SecurityLogger log = SecurityLogger.ROOT_LOGGER;
    private static final String USE_CLIENT_CERT_OPTION = "useClientCert";
    private static final String[] ALL_OPTIONS = new String[]{"useClientCert"};
    private boolean useClientCert = false;
    private Principal identity;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        if (options.containsKey(USE_CLIENT_CERT_OPTION)) {
            this.useClientCert = Boolean.parseBoolean(options.get(USE_CLIENT_CERT_OPTION).toString());
        }
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            log.debug("super.login()==true");
            return true;
        }
        Object credential = this.getCredential();
        if (credential instanceof RemotingConnectionCredential) {
            Connection con = ((RemotingConnectionCredential)credential).getConnection();
            Principal up = null;
            UserInfo userInfo = con.getUserInfo();
            if (userInfo instanceof SubjectUserInfo) {
                for (Principal current : ((SubjectUserInfo)userInfo).getPrincipals()) {
                    if (!(current instanceof RealmUser)) continue;
                    up = current;
                    break;
                }
            }
            if (up == null) {
                for (Principal current : con.getPrincipals()) {
                    if (!(current instanceof UserPrincipal)) continue;
                    up = current;
                    break;
                }
            }
            if (up != null) {
                this.identity = up;
                if (this.getUseFirstPass()) {
                    SSLSession session;
                    String userName = this.identity.getName();
                    log.debugf("Storing username '%s'", userName);
                    this.sharedState.put("javax.security.auth.login.name", this.identity);
                    if (this.useClientCert && (session = con.getSslSession()) != null) {
                        try {
                            credential = session.getPeerCertificateChain()[0];
                            log.debug("Using certificate as credential.");
                        }
                        catch (SSLPeerUnverifiedException e) {
                            log.debugf("No peer certificate available for '%s'", userName);
                        }
                    }
                    this.sharedState.put("javax.security.auth.login.password", credential);
                }
                this.loginOk = true;
                return true;
            }
        }
        return false;
    }

    protected Object getCredential() throws LoginException {
        NameCallback nc = new NameCallback("Alias: ");
        ObjectCallback oc = new ObjectCallback("Credential: ");
        Callback[] callbacks = new Callback[]{nc, oc};
        try {
            this.callbackHandler.handle(callbacks);
            return oc.getCredential();
        }
        catch (IOException ioe) {
            LoginException le = new LoginException();
            le.initCause(ioe);
            throw le;
        }
        catch (UnsupportedCallbackException uce) {
            LoginException le = new LoginException();
            le.initCause(uce);
            throw le;
        }
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        SimpleGroup callerPrincipal = new SimpleGroup("CallerPrincipal");
        Group[] groups = new Group[]{roles, callerPrincipal};
        callerPrincipal.addMember(this.getIdentity());
        return groups;
    }
}

