/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.AbstractEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.netty.transport.IoThreadPowered;
import org.xnio.netty.transport.XnioEventLoop;

public final class XnioEventLoopGroup
extends AbstractEventExecutorGroup
implements EventLoopGroup {
    private final XnioWorker worker;

    public XnioEventLoopGroup(XnioWorker worker) {
        if (worker == null) {
            throw new NullPointerException("worker");
        }
        this.worker = worker;
    }

    public XnioEventLoopGroup() throws IOException {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public XnioEventLoopGroup(int numThreads) throws IOException {
        this(Xnio.getInstance().createWorker(OptionMap.create((Option)Options.WORKER_IO_THREADS, (Object)numThreads)));
    }

    public void shutdown() {
        this.worker.shutdown();
    }

    public EventLoop next() {
        return new XnioEventLoop(this, this.worker.getIoThread());
    }

    public ChannelFuture register(Channel channel) {
        return this.register(channel, channel.newPromise());
    }

    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        if (channel instanceof IoThreadPowered) {
            IoThreadPowered ch = (IoThreadPowered)channel;
            XnioEventLoop loop = new XnioEventLoop(this, ch.ioThread());
            channel.unsafe().register((EventLoop)loop, promise);
            return promise;
        }
        return this.next().register(channel, promise);
    }

    public boolean isShuttingDown() {
        return this.worker.isTerminated();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        this.shutdown();
        if (this.isShutdown()) {
            return ImmediateEventExecutor.INSTANCE.newSucceededFuture(null);
        }
        return ImmediateEventExecutor.INSTANCE.newFailedFuture((Throwable)new TimeoutException());
    }

    public Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    public Iterator<EventExecutor> iterator() {
        throw new UnsupportedOperationException();
    }

    public boolean isShutdown() {
        return this.worker.isShutdown();
    }

    public boolean isTerminated() {
        return this.worker.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.worker.awaitTermination(timeout, unit);
    }
}

