/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.remoting.transport.Transport;

public class TransportConfiguration {
    private final String clusterName;
    private final String machineId;
    private final String rackId;
    private final String siteId;
    private final long distributedSyncTimeout;
    private final Transport transport;
    private final String nodeName;
    private final TypedProperties properties;
    private final ThreadPoolConfiguration transportThreadPool;
    private final ThreadPoolConfiguration remoteCommandThreadPool;
    private final ThreadPoolConfiguration totalOrderThreadPool;

    TransportConfiguration(String clusterName, String machineId, String rackId, String siteId, long distributedSyncTimeout, Transport transport, String nodeName, TypedProperties properties, ThreadPoolConfiguration transportThreadPool, ThreadPoolConfiguration remoteCommandThreadPool, ThreadPoolConfiguration totalOrderThreadPool) {
        this.clusterName = clusterName;
        this.machineId = machineId;
        this.rackId = rackId;
        this.siteId = siteId;
        this.distributedSyncTimeout = distributedSyncTimeout;
        this.transport = transport;
        this.nodeName = nodeName;
        this.properties = properties;
        this.transportThreadPool = transportThreadPool;
        this.remoteCommandThreadPool = remoteCommandThreadPool;
        this.totalOrderThreadPool = totalOrderThreadPool;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String machineId() {
        return this.machineId;
    }

    public String rackId() {
        return this.rackId;
    }

    public String siteId() {
        return this.siteId;
    }

    public long distributedSyncTimeout() {
        return this.distributedSyncTimeout;
    }

    public Transport transport() {
        return this.transport;
    }

    public String nodeName() {
        return this.nodeName;
    }

    @Deprecated
    public boolean strictPeerToPeer() {
        return false;
    }

    public TypedProperties properties() {
        return this.properties;
    }

    public boolean hasTopologyInfo() {
        return this.siteId() != null || this.rackId() != null || this.machineId() != null;
    }

    public ThreadPoolConfiguration transportThreadPool() {
        return this.transportThreadPool;
    }

    public ThreadPoolConfiguration remoteCommandThreadPool() {
        return this.remoteCommandThreadPool;
    }

    public ThreadPoolConfiguration totalOrderThreadPool() {
        return this.totalOrderThreadPool;
    }

    public String toString() {
        return "TransportConfiguration{clusterName='" + this.clusterName + '\'' + ", machineId='" + this.machineId + '\'' + ", rackId='" + this.rackId + '\'' + ", siteId='" + this.siteId + '\'' + ", distributedSyncTimeout=" + this.distributedSyncTimeout + ", transport=" + this.transport + ", nodeName='" + this.nodeName + '\'' + ", properties=" + this.properties + ", transportThreadPool=" + this.transportThreadPool + ", remoteCommandThreadPool=" + this.remoteCommandThreadPool + ", totalOrderThreadPool=" + this.totalOrderThreadPool + '}';
    }
}

