/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jboss.as.cli.scriptsupport.CLI;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportService;
import org.jboss.as.jdr.logger.JdrLogger;
import org.jboss.dmr.ModelNode;

public class CommandLineMain {
    private static CommandLineParser parser = new GnuParser();
    private static Options options = new Options();
    private static HelpFormatter formatter = new HelpFormatter();
    private static final String usage = "jdr.{sh,bat} [options]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int port = 9990;
        String host = "localhost";
        String protocol = "http-remoting";
        try {
            CommandLine line = parser.parse(options, args, false);
            if (line.hasOption("help")) {
                formatter.printHelp(usage, options);
                return;
            }
            if (line.hasOption("host")) {
                host = line.getOptionValue("host");
            }
            if (line.hasOption("port")) {
                port = Integer.parseInt(line.getOptionValue("port"));
            }
            if (line.hasOption("protocol")) {
                protocol = line.getOptionValue("protocol");
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp(usage, options);
            return;
        }
        catch (NumberFormatException nfe) {
            System.out.println(nfe.getMessage());
            formatter.printHelp(usage, options);
            return;
        }
        System.out.println("Initializing JBoss Diagnostic Reporter...");
        CLI cli = null;
        try {
            cli = CLI.newInstance();
            cli.connect(host, port, null, null);
            CLI.Result cmdResult = cli.cmd("/subsystem=jdr:generate-jdr-report()");
            ModelNode response = cmdResult.getResponse();
            CommandLineMain.reportFailure(response);
            ModelNode result = response.get("result");
            String startTime = result.get("start-time").asString();
            String endTime = result.get("end-time").asString();
            String reportLocation = result.get("report-location").asString();
            System.out.println("JDR started: " + startTime);
            System.out.println("JDR ended: " + endTime);
            System.out.println("JDR location: " + reportLocation);
        }
        catch (IllegalStateException ise) {
            System.out.println(ise.getMessage());
            JdrReportService reportService = new JdrReportService();
            JdrReport response = null;
            try {
                response = reportService.standaloneCollect(protocol, host, String.valueOf(port));
                System.out.println("JDR started: " + response.getStartTime().toString());
                System.out.println("JDR ended: " + response.getEndTime().toString());
                System.out.println("JDR location: " + response.getLocation());
            }
            catch (OperationFailedException e) {
                System.out.println("Failed to complete the JDR report: " + e.getMessage());
            }
        }
        finally {
            if (cli != null) {
                try {
                    cli.disconnect();
                }
                catch (Exception e) {
                    System.out.println("Caught exception while disconnecting: " + e.getMessage());
                }
            }
        }
        System.exit(0);
    }

    private static void reportFailure(ModelNode node) {
        if (!node.get("outcome").asString().equals("success")) {
            String msg = node.hasDefined("failure-description") ? (node.hasDefined("operation") ? String.format("Operation '%s' at address '%s' failed: %s", node.get("operation"), node.get("address"), node.get("failure-description")) : String.format("Operation failed: %s", node.get("failure-description"))) : String.format("Operation failed: %s", node);
            throw new RuntimeException(msg);
        }
    }

    static {
        options.addOption("h", "help", false, JdrLogger.ROOT_LOGGER.jdrHelpMessage());
        options.addOption("H", "host", true, JdrLogger.ROOT_LOGGER.jdrHostnameMessage());
        options.addOption("p", "port", true, JdrLogger.ROOT_LOGGER.jdrPortMessage());
        options.addOption("s", "protocol", true, JdrLogger.ROOT_LOGGER.jdrProtocolMessage());
    }
}

