/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.api.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ws.api.Messages;
import org.jboss.ws.api.util.SecurityActions;

public final class ServiceLoader {
    private static Map<ClassLoader, Map<String, String>> serviceMap = Collections.synchronizedMap(new WeakHashMap());

    private ServiceLoader() {
    }

    public static Object loadService(String propertyName, String defaultFactory, ClassLoader cl) {
        Object factory = ServiceLoader.loadFromServices(propertyName, cl);
        if (factory == null) {
            factory = ServiceLoader.loadFromPropertiesFile(propertyName, cl);
        }
        if (factory == null) {
            factory = ServiceLoader.loadFromSystemProperty(propertyName, defaultFactory, cl);
        }
        return factory;
    }

    public static Object loadService(String propertyName, String defaultFactory) {
        return ServiceLoader.loadService(propertyName, defaultFactory, SecurityActions.getContextClassLoader());
    }

    private static Object loadFromServices(String propertyName, ClassLoader loader) {
        Object factory = null;
        String factoryName = null;
        String filename = "META-INF/services/" + propertyName;
        try {
            factoryName = ServiceLoader.getServiceNameUsingCache(loader, filename);
            if (factoryName != null) {
                Class<?> factoryClass = SecurityActions.loadClass(loader, factoryName);
                factory = factoryClass.newInstance();
            }
        }
        catch (Throwable t) {
            throw Messages.MESSAGES.failedToLoad(t, new Object[]{propertyName, factoryName});
        }
        return factory;
    }

    private static String getServiceNameUsingCache(ClassLoader loader, String filename) throws IOException {
        Map<String, String> map = serviceMap.get(loader);
        if (map != null && map.containsKey(filename)) {
            return map.get(filename);
        }
        if (map == null) {
            map = new ConcurrentHashMap<String, String>();
            serviceMap.put(loader, map);
        }
        InputStream inStream = SecurityActions.getResourceAsStream(loader, filename);
        String factoryName = null;
        if (inStream != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
            factoryName = br.readLine();
            br.close();
            map.put(filename, factoryName);
        }
        return factoryName;
    }

    private static Object loadFromSystemProperty(String propertyName, String defaultFactory, ClassLoader loader) {
        Object factory = null;
        PropertyAccessAction action = new PropertyAccessAction(propertyName);
        String factoryName = AccessController.doPrivileged(action);
        if (factoryName != null) {
            try {
                Class<?> factoryClass = SecurityActions.loadClass(loader, factoryName);
                factory = factoryClass.newInstance();
            }
            catch (Throwable t) {
                throw Messages.MESSAGES.failedToLoad(t, new Object[]{propertyName, factoryName});
            }
        }
        if (factory == null && defaultFactory != null) {
            factory = ServiceLoader.loadDefault(defaultFactory, loader);
        }
        return factory;
    }

    private static Object loadFromPropertiesFile(String propertyName, ClassLoader loader) {
        Object factory = null;
        String factoryName = null;
        PropertyAccessAction propertyReadAction = new PropertyAccessAction("java.home");
        String javaHome = AccessController.doPrivileged(propertyReadAction);
        File jaxmFile = new File(javaHome + "/lib/jaxws.properties");
        if (AccessController.doPrivileged(new PropertyFileExistAction(jaxmFile)).booleanValue()) {
            try {
                PropertyFileAccessAction propertyFileAccessAction = new PropertyFileAccessAction(jaxmFile.getCanonicalPath());
                Properties jaxmProperties = AccessController.doPrivileged(propertyFileAccessAction);
                factoryName = jaxmProperties.getProperty(propertyName);
                if (factoryName != null) {
                    Class<?> factoryClass = SecurityActions.loadClass(loader, factoryName);
                    factory = factoryClass.newInstance();
                }
            }
            catch (Throwable t) {
                throw Messages.MESSAGES.failedToLoad(t, new Object[]{propertyName, factoryName});
            }
        }
        return factory;
    }

    private static Object loadDefault(String defaultFactory, ClassLoader loader) {
        Object factory = null;
        if (defaultFactory != null) {
            try {
                Class<?> factoryClass = SecurityActions.loadClass(loader, defaultFactory);
                factory = factoryClass.newInstance();
            }
            catch (Throwable t) {
                throw Messages.MESSAGES.failedToLoad(t, defaultFactory);
            }
        }
        return factory;
    }

    private static class PropertyFileExistAction
    implements PrivilegedAction<Boolean> {
        private File file;

        PropertyFileExistAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            return this.file.exists();
        }
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction<Properties> {
        private String filename;

        PropertyFileAccessAction(String filename) {
            this.filename = filename;
        }

        @Override
        public Properties run() {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(this.filename);
                Properties props = new Properties();
                props.load(inStream);
                Properties properties = props;
                return properties;
            }
            catch (IOException ex) {
                throw Messages.MESSAGES.cannotLoadProperties(ex, this.filename);
            }
            finally {
                try {
                    if (inStream != null) {
                        ((InputStream)inStream).close();
                    }
                }
                catch (Exception ignore) {}
            }
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction<String> {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        @Override
        public String run() {
            return System.getProperty(this.name);
        }
    }
}

