/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.EnumSet;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLAttribute;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLElement;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EJBClientDescriptor10Parser
implements XMLElementReader<EJBClientDescriptorMetaData> {
    public static final String NAMESPACE_1_0 = "urn:jboss:ejb-client:1.0";
    protected final PropertyReplacer propertyReplacer;

    protected EJBClientDescriptor10Parser(PropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    public void readElement(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case CLIENT_CONTEXT: {
                            this.parseClientContext(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor10Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor10Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected void parseClientContext(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        EnumSet<EJBClientDescriptorXMLElement> visited = EnumSet.noneOf(EJBClientDescriptorXMLElement.class);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    if (visited.contains((Object)element)) {
                        EJBClientDescriptor10Parser.unexpectedElement(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EJB_RECEIVERS: {
                            this.parseEJBReceivers(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor10Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor10Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected void parseEJBReceivers(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        Boolean localReceiverPassByValue = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case EXCLUDE_LOCAL_RECEIVER: {
                    boolean excludeLocalReceiver = Boolean.parseBoolean(value);
                    ejbClientDescriptorMetaData.setExcludeLocalReceiver(excludeLocalReceiver);
                    continue block11;
                }
                case LOCAL_RECEIVER_PASS_BY_VALUE: {
                    localReceiverPassByValue = Boolean.parseBoolean(value);
                    continue block11;
                }
                default: {
                    EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        ejbClientDescriptorMetaData.setLocalReceiverPassByValue(localReceiverPassByValue);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case REMOTING_EJB_RECEIVER: {
                            this.parseRemotingReceiver(reader, ejbClientDescriptorMetaData);
                            continue block12;
                        }
                    }
                    EJBClientDescriptor10Parser.unexpectedElement(reader);
                    continue block12;
                }
            }
            EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor10Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected void parseRemotingReceiver(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        String outboundConnectionRef = null;
        EnumSet<EJBClientDescriptorXMLAttribute> required = EnumSet.of(EJBClientDescriptorXMLAttribute.OUTBOUND_CONNECTION_REF);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case OUTBOUND_CONNECTION_REF: {
                    outboundConnectionRef = this.readResolveValue(reader, i);
                    ejbClientDescriptorMetaData.addRemotingReceiverConnectionRef(outboundConnectionRef);
                    continue block3;
                }
                default: {
                    EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor10Parser.missingAttributes(reader.getLocation(), required);
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
        }
    }

    protected static void unexpectedEndOfDocument(Location location) throws XMLStreamException {
        throw EeLogger.ROOT_LOGGER.errorParsingEJBClientDescriptor("Unexpected end of document", location);
    }

    protected static void missingAttributes(Location location, Set<EJBClientDescriptorXMLAttribute> required) throws XMLStreamException {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (EJBClientDescriptorXMLAttribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        throw EeLogger.ROOT_LOGGER.errorParsingEJBClientDescriptor(b.toString(), location);
    }

    protected static void unexpectedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        throw EeLogger.ROOT_LOGGER.unexpectedElement(reader.getName(), reader.getLocation());
    }

    protected static void unexpectedContent(XMLStreamReader reader) throws XMLStreamException {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        throw EeLogger.ROOT_LOGGER.errorParsingEJBClientDescriptor(b.toString(), reader.getLocation());
    }

    protected String readResolveValue(XMLExtendedStreamReader reader, int index) {
        return this.propertyReplacer.replaceProperties(reader.getAttributeValue(index).trim());
    }
}

