/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.ee.component.deployers.DefaultBindingsConfigurationProcessor;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.subsystem.BeanValidationProfileParsingCompletionHandler;
import org.jboss.as.ee.subsystem.ContextServiceResourceDefinition;
import org.jboss.as.ee.subsystem.DefaultBindingsResourceDefinition;
import org.jboss.as.ee.subsystem.EESubsystemModel;
import org.jboss.as.ee.subsystem.EESubsystemParser10;
import org.jboss.as.ee.subsystem.EESubsystemParser11;
import org.jboss.as.ee.subsystem.EESubsystemParser20;
import org.jboss.as.ee.subsystem.EESubsystemXmlPersister;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.ee.subsystem.ManagedExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedScheduledExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedThreadFactoryResourceDefinition;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class EeExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "ee";
    private static final String RESOURCE_NAME = EeExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)3, (int)0, (int)0);
    protected static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"ee");

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, EeExtension.class.getClassLoader(), true, true);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration rootResource = subsystem.registerSubsystemModel((ResourceDefinition)EeSubsystemRootResource.create());
        rootResource.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        rootResource.registerSubModel((ResourceDefinition)ContextServiceResourceDefinition.INSTANCE);
        rootResource.registerSubModel((ResourceDefinition)ManagedThreadFactoryResourceDefinition.INSTANCE);
        rootResource.registerSubModel((ResourceDefinition)ManagedExecutorServiceResourceDefinition.INSTANCE);
        rootResource.registerSubModel((ResourceDefinition)ManagedScheduledExecutorServiceResourceDefinition.INSTANCE);
        rootResource.registerSubModel((ResourceDefinition)new DefaultBindingsResourceDefinition(new DefaultBindingsConfigurationProcessor()));
        subsystem.registerXMLElementWriter((XMLElementWriter)EESubsystemXmlPersister.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.EE_1_0.getUriString(), (XMLElementReader)EESubsystemParser10.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.EE_1_1.getUriString(), (XMLElementReader)EESubsystemParser11.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.EE_2_0.getUriString(), (XMLElementReader)EESubsystemParser20.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.EE_3_0.getUriString(), (XMLElementReader)EESubsystemParser20.INSTANCE);
        context.setProfileParsingCompletionHandler((ProfileParsingCompletionHandler)new BeanValidationProfileParsingCompletionHandler());
    }

    private void registerTransformers(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        GlobalModulesRejecterConverter globalModulesRejecterConverter = new GlobalModulesRejecterConverter();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new JBossDescriptorPropertyReplacementRejectChecker(), new AttributeDefinition[]{EeSubsystemRootResource.JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT})).addRejectCheck((RejectAttributeChecker)globalModulesRejecterConverter, new AttributeDefinition[]{GlobalModulesDefinition.INSTANCE})).setValueConverter((AttributeConverter)globalModulesRejecterConverter, new AttributeDefinition[]{GlobalModulesDefinition.INSTANCE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EeSubsystemRootResource.ANNOTATION_PROPERTY_REPLACEMENT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EeSubsystemRootResource.ANNOTATION_PROPERTY_REPLACEMENT});
        builder.rejectChildResource(PathElement.pathElement((String)"context-service"));
        builder.rejectChildResource(PathElement.pathElement((String)"managed-thread-factory"));
        builder.rejectChildResource(PathElement.pathElement((String)"managed-executor-service"));
        builder.rejectChildResource(PathElement.pathElement((String)"managed-scheduled-executor-service"));
        builder.discardChildResource(EESubsystemModel.DEFAULT_BINDINGS_PATH);
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)0, (int)0));
    }

    private static class GlobalModulesRejecterConverter
    extends RejectAttributeChecker.DefaultRejectAttributeChecker
    implements AttributeConverter {
        private final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");

        private GlobalModulesRejecterConverter() {
        }

        public void convertOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            this.cleanModel(attributeValue);
        }

        public void convertResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            this.cleanModel(attributeValue);
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode node : attributeValue.asList()) {
                    ModelNode metaInf;
                    ModelNode services;
                    ModelNode annotations;
                    if (node.hasDefined("annotations") && (this.EXPRESSION_PATTERN.matcher((annotations = node.get("annotations")).asString()).matches() || annotations.asBoolean())) {
                        return true;
                    }
                    if (node.hasDefined("services") && (this.EXPRESSION_PATTERN.matcher((services = node.get("services")).asString()).matches() || !services.asBoolean())) {
                        return true;
                    }
                    if (!node.hasDefined("meta-inf") || !this.EXPRESSION_PATTERN.matcher((metaInf = node.get("meta-inf")).asString()).matches() && !metaInf.asBoolean()) continue;
                    return true;
                }
            }
            return false;
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return EeLogger.ROOT_LOGGER.propertiesNotAllowedOnGlobalModules();
        }

        private void cleanModel(ModelNode attributeValue) {
            if (attributeValue.isDefined()) {
                for (ModelNode node : attributeValue.asList()) {
                    node.remove("annotations");
                    node.remove("services");
                    node.remove("meta-inf");
                }
            }
        }
    }

    private static class JBossDescriptorPropertyReplacementRejectChecker
    extends RejectAttributeChecker.DefaultRejectAttributeChecker {
        private JBossDescriptorPropertyReplacementRejectChecker() {
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return EeLogger.ROOT_LOGGER.onlyTrueAllowedForJBossDescriptorPropertyReplacement_AS7_4892();
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            ModelVersion version;
            if (attributeValue.isDefined() && (version = context.getTarget().getVersion()).getMajor() == 1 && version.getMinor() == 2) {
                if (attributeValue.getType() == ModelType.BOOLEAN) {
                    return !attributeValue.asBoolean();
                }
                if (!Boolean.parseBoolean(attributeValue.asString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

