/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeHealthChecker;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.XnioSsl;

class NodePingUtil {
    private static final ClientRequest PING_REQUEST;

    NodePingUtil() {
    }

    static void pingHost(InetSocketAddress address, HttpServerExchange exchange, PingCallback callback, OptionMap options) {
        XnioIoThread thread = exchange.getIoThread();
        XnioWorker worker = thread.getWorker();
        HostPingTask r = new HostPingTask(address, worker, callback, options);
        NodePingUtil.scheduleCancelTask(exchange.getIoThread(), r, 5L, TimeUnit.SECONDS);
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : thread, r);
    }

    static void pingHttpClient(URI connection, PingCallback callback, HttpServerExchange exchange, UndertowClient client, XnioSsl xnioSsl, OptionMap options) {
        XnioIoThread thread = exchange.getIoThread();
        RequestExchangeListener exchangeListener = new RequestExchangeListener(callback, NodeHealthChecker.NO_CHECK, true);
        HttpClientPingTask r = new HttpClientPingTask(connection, exchangeListener, thread, client, xnioSsl, exchange.getConnection().getBufferPool(), options);
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : thread, r);
        NodePingUtil.scheduleCancelTask(exchange.getIoThread(), exchangeListener, 5L, TimeUnit.SECONDS);
    }

    static void pingNode(final Node node, final HttpServerExchange exchange, final PingCallback callback) {
        if (node == null) {
            callback.failed();
            return;
        }
        final int timeout = node.getNodeConfig().getPing();
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : exchange.getIoThread(), new Runnable(){

            @Override
            public void run() {
                node.getConnectionPool().connect(null, exchange, new ProxyCallback<ProxyConnection>(){

                    @Override
                    public void completed(HttpServerExchange exchange, ProxyConnection result) {
                        RequestExchangeListener exchangeListener = new RequestExchangeListener(callback, NodeHealthChecker.NO_CHECK, false);
                        exchange.dispatch(SameThreadExecutor.INSTANCE, new ConnectionPoolPingTask(result, exchangeListener));
                        NodePingUtil.scheduleCancelTask(exchange.getIoThread(), exchangeListener, timeout, TimeUnit.SECONDS);
                    }

                    @Override
                    public void failed(HttpServerExchange exchange) {
                        callback.failed();
                    }

                    @Override
                    public void queuedRequestFailed(HttpServerExchange exchange) {
                        callback.failed();
                    }

                    @Override
                    public void couldNotResolveBackend(HttpServerExchange exchange) {
                        callback.failed();
                    }
                }, timeout, TimeUnit.SECONDS, false);
            }
        });
    }

    static void internalPingNode(Node node, PingCallback callback, NodeHealthChecker healthChecker, XnioIoThread ioThread, Pool<ByteBuffer> bufferPool, UndertowClient client, XnioSsl xnioSsl, OptionMap options) {
        URI uri = node.getNodeConfig().getConnectionURI();
        long timeout = node.getNodeConfig().getPing();
        RequestExchangeListener exchangeListener = new RequestExchangeListener(callback, healthChecker, true);
        HttpClientPingTask r = new HttpClientPingTask(uri, exchangeListener, ioThread, client, xnioSsl, bufferPool, options);
        NodePingUtil.scheduleCancelTask(ioThread, exchangeListener, timeout, TimeUnit.SECONDS);
        ioThread.execute((Runnable)r);
    }

    static void scheduleCancelTask(XnioIoThread ioThread, final CancellableTask cancellable, long timeout, TimeUnit timeUnit) {
        XnioExecutor.Key key = ioThread.executeAfter(new Runnable(){

            @Override
            public void run() {
                cancellable.cancel();
            }
        }, timeout, timeUnit);
        cancellable.setCancelKey(key);
    }

    static {
        ClientRequest request = new ClientRequest();
        request.setMethod(Methods.OPTIONS);
        request.setPath("*");
        request.getRequestHeaders().add(Headers.USER_AGENT, "mod_cluster ping");
        PING_REQUEST = request;
    }

    static class CancellableTask {
        private final PingCallback delegate;
        private volatile State state = State.WAITING;
        private volatile XnioExecutor.Key cancelKey;

        CancellableTask(PingCallback callback) {
            this.delegate = callback;
        }

        boolean isDone() {
            return this.state != State.WAITING;
        }

        void setCancelKey(XnioExecutor.Key cancelKey) {
            if (this.state == State.WAITING) {
                this.cancelKey = cancelKey;
            } else {
                cancelKey.remove();
            }
        }

        void taskCompleted() {
            if (this.state == State.WAITING) {
                this.state = State.DONE;
                if (this.cancelKey != null) {
                    this.cancelKey.remove();
                }
                this.delegate.completed();
            }
        }

        void taskFailed() {
            if (this.state == State.WAITING) {
                this.state = State.DONE;
                if (this.cancelKey != null) {
                    this.cancelKey.remove();
                }
                this.delegate.failed();
            }
        }

        void cancel() {
            if (this.state == State.WAITING) {
                this.state = State.CANCELLED;
                if (this.cancelKey != null) {
                    this.cancelKey.remove();
                }
                this.delegate.failed();
            }
        }
    }

    static enum State {
        WAITING,
        DONE,
        CANCELLED;

    }

    static class RequestExchangeListener
    extends CancellableTask
    implements ClientCallback<ClientExchange> {
        private ClientExchange exchange;
        private final boolean closeConnection;
        private final NodeHealthChecker healthChecker;

        RequestExchangeListener(PingCallback callback, NodeHealthChecker healthChecker, boolean closeConnection) {
            super(callback);
            assert (healthChecker != null);
            this.closeConnection = closeConnection;
            this.healthChecker = healthChecker;
        }

        @Override
        public void completed(final ClientExchange result) {
            if (this.isDone()) {
                IoUtils.safeClose((Closeable)result.getConnection());
                return;
            }
            ChannelListener listener = ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)new ChannelListener<StreamSourceChannel>(){

                public void handleEvent(StreamSourceChannel channel) {
                    try {
                        if (RequestExchangeListener.this.healthChecker.checkResponse(result.getResponse())) {
                            RequestExchangeListener.this.taskCompleted();
                        } else {
                            RequestExchangeListener.this.taskFailed();
                        }
                    }
                    finally {
                        if (RequestExchangeListener.this.closeConnection && RequestExchangeListener.this.exchange != null) {
                            IoUtils.safeClose((Closeable)RequestExchangeListener.this.exchange.getConnection());
                        }
                    }
                }
            }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSourceChannel>(){

                public void handleException(StreamSourceChannel channel, IOException exception) {
                    RequestExchangeListener.this.taskFailed();
                    if (exception != null) {
                        IoUtils.safeClose((Closeable)RequestExchangeListener.this.exchange.getConnection());
                    }
                }
            });
            StreamSourceChannel responseChannel = result.getResponseChannel();
            responseChannel.getReadSetter().set(listener);
            responseChannel.resumeReads();
            listener.handleEvent((Channel)responseChannel);
        }

        @Override
        public void failed(IOException e) {
            this.taskFailed();
            if (this.exchange != null) {
                IoUtils.safeClose((Closeable)this.exchange.getConnection());
            }
        }
    }

    static class HttpClientPingTask
    implements Runnable {
        private final URI connection;
        private final XnioIoThread thread;
        private final UndertowClient client;
        private final XnioSsl xnioSsl;
        private final Pool<ByteBuffer> bufferPool;
        private final OptionMap options;
        private final RequestExchangeListener exchangeListener;

        HttpClientPingTask(URI connection, RequestExchangeListener exchangeListener, XnioIoThread thread, UndertowClient client, XnioSsl xnioSsl, Pool<ByteBuffer> bufferPool, OptionMap options) {
            this.connection = connection;
            this.thread = thread;
            this.client = client;
            this.xnioSsl = xnioSsl;
            this.bufferPool = bufferPool;
            this.options = options;
            this.exchangeListener = exchangeListener;
        }

        @Override
        public void run() {
            this.client.connect(new ClientCallback<ClientConnection>(){

                @Override
                public void completed(final ClientConnection clientConnection) {
                    if (HttpClientPingTask.this.exchangeListener.isDone()) {
                        IoUtils.safeClose((Closeable)clientConnection);
                        return;
                    }
                    clientConnection.sendRequest(PING_REQUEST, new ClientCallback<ClientExchange>(){

                        @Override
                        public void completed(ClientExchange result) {
                            HttpClientPingTask.this.exchangeListener.exchange = result;
                            if (HttpClientPingTask.this.exchangeListener.isDone()) {
                                return;
                            }
                            result.setResponseListener(HttpClientPingTask.this.exchangeListener);
                            try {
                                result.getRequestChannel().shutdownWrites();
                                if (!result.getRequestChannel().flush()) {
                                    result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkChannel>(){

                                        public void handleException(StreamSinkChannel channel, IOException exception) {
                                            IoUtils.safeClose((Closeable)clientConnection);
                                            HttpClientPingTask.this.exchangeListener.taskFailed();
                                        }
                                    }));
                                    result.getRequestChannel().resumeWrites();
                                }
                            }
                            catch (IOException e) {
                                IoUtils.safeClose((Closeable)clientConnection);
                                HttpClientPingTask.this.exchangeListener.taskFailed();
                            }
                        }

                        @Override
                        public void failed(IOException e) {
                            HttpClientPingTask.this.exchangeListener.taskFailed();
                            IoUtils.safeClose((Closeable)clientConnection);
                        }
                    });
                }

                @Override
                public void failed(IOException e) {
                    HttpClientPingTask.this.exchangeListener.taskFailed();
                }
            }, this.connection, this.thread, this.xnioSsl, this.bufferPool, this.options);
        }
    }

    static class HostPingTask
    extends CancellableTask
    implements Runnable {
        private final InetSocketAddress address;
        private final XnioWorker worker;
        private final OptionMap options;

        HostPingTask(InetSocketAddress address, XnioWorker worker, PingCallback callback, OptionMap options) {
            super(callback);
            this.address = address;
            this.worker = worker;
            this.options = options;
        }

        @Override
        public void run() {
            try {
                IoFuture future = this.worker.openStreamConnection((SocketAddress)this.address, (ChannelListener)new ChannelListener<StreamConnection>(){

                    public void handleEvent(StreamConnection channel) {
                        IoUtils.safeClose((Closeable)channel);
                    }
                }, this.options);
                future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<StreamConnection, Void>(){

                    public void handleCancelled(Void attachment) {
                        HostPingTask.this.cancel();
                    }

                    public void handleFailed(IOException exception, Void attachment) {
                        HostPingTask.this.taskFailed();
                    }

                    public void handleDone(StreamConnection data, Void attachment) {
                        HostPingTask.this.taskCompleted();
                    }
                }, null);
            }
            catch (Exception e) {
                this.taskFailed();
            }
        }
    }

    static class ConnectionPoolPingTask
    implements Runnable {
        private final RequestExchangeListener exchangeListener;
        private final ProxyConnection proxyConnection;

        ConnectionPoolPingTask(ProxyConnection proxyConnection, RequestExchangeListener exchangeListener) {
            this.proxyConnection = proxyConnection;
            this.exchangeListener = exchangeListener;
        }

        @Override
        public void run() {
            this.proxyConnection.getConnection().sendRequest(PING_REQUEST, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(ClientExchange result) {
                    if (ConnectionPoolPingTask.this.exchangeListener.isDone()) {
                        IoUtils.safeClose((Closeable)ConnectionPoolPingTask.this.proxyConnection.getConnection());
                        return;
                    }
                    ConnectionPoolPingTask.this.exchangeListener.exchange = result;
                    result.setResponseListener(ConnectionPoolPingTask.this.exchangeListener);
                    try {
                        result.getRequestChannel().shutdownWrites();
                        if (!result.getRequestChannel().flush()) {
                            result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkChannel>(){

                                public void handleException(StreamSinkChannel channel, IOException exception) {
                                    IoUtils.safeClose((Closeable)ConnectionPoolPingTask.this.proxyConnection.getConnection());
                                    ConnectionPoolPingTask.this.exchangeListener.taskFailed();
                                }
                            }));
                            result.getRequestChannel().resumeWrites();
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)ConnectionPoolPingTask.this.proxyConnection.getConnection());
                        ConnectionPoolPingTask.this.exchangeListener.taskFailed();
                    }
                }

                @Override
                public void failed(IOException e) {
                    ConnectionPoolPingTask.this.exchangeListener.taskFailed();
                }
            });
        }
    }

    static interface PingCallback {
        public void completed();

        public void failed();
    }
}

