/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.RootClassNode;
import org.jboss.resteasy.core.registry.RootNode;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.resourcefactory.JndiResourceFactory;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.metadata.ResourceMethod;
import org.jboss.resteasy.util.GetRestful;
import org.jboss.resteasy.util.IsHttpMethod;
import org.jboss.resteasy.util.Types;

public class ResourceMethodRegistry
implements Registry {
    public static final String REGISTRY_MATCHING_EXCEPTION = "registry.matching.exception";
    protected ResteasyProviderFactory providerFactory;
    protected RootClassNode root = new RootClassNode();
    protected boolean widerMatching;
    protected RootNode rootNode = new RootNode();
    private static final Logger logger = Logger.getLogger(ResourceMethodRegistry.class);

    public ResourceMethodRegistry(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public boolean isWiderMatching() {
        return this.widerMatching;
    }

    public void setWiderMatching(boolean widerMatching) {
        this.widerMatching = widerMatching;
    }

    public void addPerRequestResource(Class clazz, String basePath) {
        this.addResourceFactory(new POJOResourceFactory(clazz), basePath);
    }

    public void addPerRequestResource(Class clazz) {
        this.addResourceFactory(new POJOResourceFactory(clazz));
    }

    @Override
    public void addPerRequestResource(ResourceClass clazz) {
        POJOResourceFactory resourceFactory = new POJOResourceFactory(clazz);
        this.register(resourceFactory, null, clazz);
        if (resourceFactory != null) {
            resourceFactory.registered(this.providerFactory);
        }
    }

    @Override
    public void addPerRequestResource(ResourceClass clazz, String basePath) {
        POJOResourceFactory resourceFactory = new POJOResourceFactory(clazz);
        this.register(resourceFactory, basePath, clazz);
        if (resourceFactory != null) {
            resourceFactory.registered(this.providerFactory);
        }
    }

    @Override
    public void addSingletonResource(Object singleton) {
        this.addResourceFactory(new SingletonResource(singleton));
    }

    @Override
    public void addSingletonResource(Object singleton, String basePath) {
        this.addResourceFactory(new SingletonResource(singleton), basePath);
    }

    @Override
    public void addSingletonResource(Object singleton, ResourceClass resourceClass) {
        SingletonResource resourceFactory = new SingletonResource(singleton, resourceClass);
        this.register(resourceFactory, null, resourceClass);
        if (resourceFactory != null) {
            resourceFactory.registered(this.providerFactory);
        }
    }

    @Override
    public void addSingletonResource(Object singleton, ResourceClass resourceClass, String basePath) {
        SingletonResource resourceFactory = new SingletonResource(singleton);
        this.register(resourceFactory, basePath, resourceClass);
        if (resourceFactory != null) {
            resourceFactory.registered(this.providerFactory);
        }
    }

    @Override
    public void addJndiResource(String jndiName) {
        this.addResourceFactory(new JndiResourceFactory(jndiName));
    }

    @Override
    public void addJndiResource(String jndiName, String basePath) {
        this.addResourceFactory(new JndiResourceFactory(jndiName), basePath);
    }

    @Override
    public void addJndiResource(String jndiName, ResourceClass resourceClass) {
        JndiResourceFactory resourceFactory = new JndiResourceFactory(jndiName);
        this.register(resourceFactory, null, resourceClass);
        if (resourceFactory != null) {
            resourceFactory.registered(this.providerFactory);
        }
    }

    @Override
    public void addJndiResource(String jndiName, ResourceClass resourceClass, String basePath) {
        JndiResourceFactory resourceFactory = new JndiResourceFactory(jndiName);
        this.register(resourceFactory, basePath, resourceClass);
        if (resourceFactory != null) {
            resourceFactory.registered(this.providerFactory);
        }
    }

    @Override
    public void addResourceFactory(ResourceFactory ref) {
        this.addResourceFactory(ref, null);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base) {
        Class<?> clazz = ref.getScannableClass();
        Class restful = GetRestful.getRootResourceClass(clazz);
        if (restful == null) {
            String msg = "Class is not a root resource.  It, or one of its interfaces must be annotated with @Path: " + clazz.getName() + " implements: ";
            for (Class<?> intf : clazz.getInterfaces()) {
                msg = msg + " " + intf.getName();
            }
            throw new RuntimeException(msg);
        }
        this.addResourceFactory(ref, base, restful);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base, Class<?> clazz) {
        Class[] classes = new Class[]{clazz};
        this.addResourceFactory(ref, base, classes);
        if (ref != null) {
            ref.registered(this.providerFactory);
        }
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base, Class<?>[] classes) {
        if (ref != null) {
            ref.registered(this.providerFactory);
        }
        for (Class<?> clazz : classes) {
            if (Proxy.isProxyClass(clazz)) {
                for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                    ResourceClass resourceClass = ResourceBuilder.rootResourceFromAnnotations(genericDeclaration);
                    this.register(ref, base, resourceClass);
                }
                continue;
            }
            ResourceClass resourceClass = ResourceBuilder.rootResourceFromAnnotations(clazz);
            this.register(ref, base, resourceClass);
        }
        for (Class<?> clazz : classes) {
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                Method _method = this.findAnnotatedMethod(clazz, (Method)genericDeclaration);
                if (_method == null || Modifier.isPublic(_method.getModifiers())) continue;
                logger.warn("JAX-RS annotations found at non-public method: " + ((Method)genericDeclaration).getDeclaringClass().getName() + "." + ((Method)genericDeclaration).getName() + "(); Only public methods may be exposed as resource methods.");
            }
        }
    }

    @Override
    public void addResourceFactory(ResourceFactory rf, String base, ResourceClass resourceClass) {
        if (rf != null) {
            rf.registered(this.providerFactory);
        }
        this.register(rf, base, resourceClass);
    }

    protected void register(ResourceFactory rf, String base, ResourceClass resourceClass) {
        for (ResourceMethod resourceMethod : resourceClass.getResourceMethods()) {
            this.processMethod(rf, base, resourceMethod);
        }
        for (ResourceLocator resourceLocator : resourceClass.getResourceLocators()) {
            this.processMethod(rf, base, resourceLocator);
        }
    }

    protected void processMethod(ResourceFactory rf, String base, ResourceLocator method) {
        ResteasyUriBuilder builder = new ResteasyUriBuilder();
        if (base != null) {
            builder.path(base);
        }
        builder.path(method.getFullpath());
        String fullpath = builder.getPath();
        if (fullpath == null) {
            fullpath = "";
        }
        builder = new ResteasyUriBuilder();
        if (base != null) {
            builder.path(base);
        }
        builder.path(method.getResourceClass().getPath());
        String classExpression = builder.getPath();
        if (classExpression == null) {
            classExpression = "";
        }
        InjectorFactory injectorFactory = this.providerFactory.getInjectorFactory();
        if (method instanceof ResourceMethod) {
            ResourceMethodInvoker invoker = new ResourceMethodInvoker((ResourceMethod)method, injectorFactory, rf, this.providerFactory);
            if (this.widerMatching) {
                this.rootNode.addInvoker(fullpath, invoker);
            } else {
                this.root.addInvoker(classExpression, fullpath, invoker);
            }
        } else {
            ResourceLocatorInvoker locator = new ResourceLocatorInvoker(rf, injectorFactory, this.providerFactory, method);
            if (this.widerMatching) {
                this.rootNode.addInvoker(fullpath, locator);
            } else {
                this.root.addInvoker(classExpression, fullpath, locator);
            }
        }
    }

    private Method findAnnotatedInterfaceMethod(Class<?> root, Class<?> iface, Method implementation) {
        for (Method method : iface.getMethods()) {
            Method actual;
            if (method.isSynthetic() || !method.getName().equals(implementation.getName()) || method.getParameterTypes().length != implementation.getParameterTypes().length || !(actual = Types.getImplementingMethod(root, method)).equals(implementation) || !method.isAnnotationPresent(Path.class) && IsHttpMethod.getHttpMethods(method) == null) continue;
            return method;
        }
        for (GenericDeclaration genericDeclaration : iface.getInterfaces()) {
            Method m = this.findAnnotatedInterfaceMethod(root, (Class<?>)genericDeclaration, implementation);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private Method findAnnotatedMethod(Class<?> root, Method implementation) {
        Method method;
        Class<?> clazz;
        if (implementation.isAnnotationPresent(Path.class) || IsHttpMethod.getHttpMethods(implementation) != null) {
            return implementation;
        }
        for (clazz = implementation.getDeclaringClass().getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(implementation.getName(), implementation.getParameterTypes());
                if (!method.isAnnotationPresent(Path.class) && IsHttpMethod.getHttpMethods(method) == null) continue;
                return method;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (clazz = root; clazz != null; clazz = clazz.getSuperclass()) {
            method = null;
            for (Class<?> iface : clazz.getInterfaces()) {
                Method m = this.findAnnotatedInterfaceMethod(root, iface, implementation);
                if (m == null) continue;
                if (method != null && !m.equals(method)) {
                    throw new RuntimeException("Ambiguous inherited JAX-RS annotations applied to method: " + implementation);
                }
                method = m;
            }
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public void removeRegistrations(Class clazz) {
        this.removeRegistrations(clazz, (String)null);
    }

    public void removeRegistrations(Class clazz, String base) {
        Class restful = GetRestful.getRootResourceClass(clazz);
        this.removeRegistration(base, restful);
    }

    @Override
    public void removeRegistrations(ResourceClass resourceClass) {
        for (ResourceMethod resourceMethod : resourceClass.getResourceMethods()) {
            if (this.widerMatching) {
                this.rootNode.removeBinding(resourceMethod.getFullpath(), resourceMethod.getMethod());
                continue;
            }
            this.root.removeBinding(resourceClass.getPath(), resourceMethod.getFullpath(), resourceMethod.getMethod());
        }
        for (ResourceLocator resourceLocator : resourceClass.getResourceLocators()) {
            if (this.widerMatching) {
                this.rootNode.removeBinding(resourceLocator.getFullpath(), resourceLocator.getMethod());
                continue;
            }
            this.root.removeBinding(resourceClass.getPath(), resourceLocator.getFullpath(), resourceLocator.getMethod());
        }
    }

    private void removeRegistration(String base, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            String fullpath;
            Path path = method.getAnnotation(Path.class);
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (path == null && httpMethods == null) continue;
            ResteasyUriBuilder builder = new ResteasyUriBuilder();
            if (base != null) {
                builder.path(base);
            }
            if (clazz.isAnnotationPresent(Path.class)) {
                builder.path(clazz);
            }
            String classExpression = builder.getPath();
            if (path != null) {
                builder.path(method);
            }
            if ((fullpath = builder.getPath()) == null) {
                fullpath = "";
            }
            if (this.widerMatching) {
                this.rootNode.removeBinding(fullpath, method);
                continue;
            }
            this.root.removeBinding(classExpression, fullpath, method);
        }
    }

    public Map<String, List<ResourceInvoker>> getBounded() {
        if (this.widerMatching) {
            return this.rootNode.getBounded();
        }
        return this.root.getBounded();
    }

    @Override
    public int getSize() {
        if (this.widerMatching) {
            return this.rootNode.getSize();
        }
        return this.root.getSize();
    }

    @Override
    public ResourceInvoker getResourceInvoker(HttpRequest request) {
        if (this.widerMatching) {
            return this.rootNode.match(request, 0);
        }
        return this.root.match(request, 0);
    }
}

