/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.io.BlockingSenderImpl;
import io.undertow.io.Sender;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.core.BlockingWriterSenderImpl;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletBlockingHttpExchange
implements BlockingHttpExchange {
    private final HttpServerExchange exchange;

    public ServletBlockingHttpExchange(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    public InputStream getInputStream() {
        ServletRequest request = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletRequest();
        try {
            return request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream() {
        ServletResponse response = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletResponse();
        try {
            return response.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Sender getSender() {
        try {
            return new BlockingSenderImpl(this.exchange, this.getOutputStream());
        }
        catch (IllegalStateException e) {
            ServletResponse response = ((ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletResponse();
            try {
                return new BlockingWriterSenderImpl(this.exchange, response.getWriter(), response.getCharacterEncoding());
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (!this.exchange.isComplete()) {
            try {
                HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
                request.closeAndDrainRequest();
            }
            finally {
                HttpServletResponseImpl response = servletRequestContext.getOriginalResponse();
                response.closeStreamAndWriter();
            }
        }
        try {
            HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
            request.freeResources();
        }
        finally {
            HttpServletResponseImpl response = servletRequestContext.getOriginalResponse();
            response.freeResources();
        }
    }
}

