/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.api.GSSAPIServerSubjectFactory;
import java.security.GeneralSecurityException;
import javax.security.auth.Subject;
import org.jboss.as.domain.http.server.security.RealmIdentityManager;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.SubjectIdentity;

public class ServerSubjectFactory
implements GSSAPIServerSubjectFactory {
    private static final String HTTP_PROTOCOL = "HTTP";
    private final SecurityRealm securityRealm;
    private final RealmIdentityManager realmIdentityManager;

    public ServerSubjectFactory(SecurityRealm securityRealm, RealmIdentityManager realmIdentityManager) {
        this.securityRealm = securityRealm;
        this.realmIdentityManager = realmIdentityManager;
    }

    public Subject getSubjectForHost(String hostName) throws GeneralSecurityException {
        SubjectIdentity subjectIdentity = this.securityRealm.getSubjectIdentity(HTTP_PROTOCOL, hostName);
        if (subjectIdentity != null) {
            this.realmIdentityManager.setCurrentSubjectIdentity(subjectIdentity);
        }
        return subjectIdentity == null ? null : subjectIdentity.getSubject();
    }
}

