/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.batch.operations.JobStartException;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.BatchArtifacts;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobMerger;
import org.jberet.job.model.JobParser;
import org.jberet.spi.JobXmlResolver;

public class ArchiveXmlLoader {
    public static final String ARCHIVE_JOB_XML_DIR = "META-INF/batch-jobs/";
    public static final String ARCHIVE_BATCH_XML = "META-INF/batch.xml";

    public static BatchArtifacts loadBatchXml(ClassLoader classLoader) throws JobStartException {
        BatchArtifacts batchArtifacts = null;
        InputStream is = classLoader.getResourceAsStream(ARCHIVE_BATCH_XML);
        if (is == null) {
            return null;
        }
        try {
            batchArtifacts = JobParser.parseBatchArtifacts(is);
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToParseBatchXml(e, ARCHIVE_BATCH_XML);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return batchArtifacts;
    }

    public static Job loadJobXml(String jobXmlName, ClassLoader classLoader, List<Job> loadedJobs, JobXmlResolver jobXmlResolver) throws JobStartException {
        InputStream is;
        for (Job j : loadedJobs) {
            if (!jobXmlName.equals(j.getJobXmlName() != null ? j.getJobXmlName() : j.getId())) continue;
            return j;
        }
        Job job = null;
        try {
            is = ArchiveXmlLoader.getJobXml(jobXmlName, classLoader, jobXmlResolver);
        }
        catch (IOException e) {
            throw BatchMessages.MESSAGES.failToGetJobXml(e, jobXmlName);
        }
        try {
            job = JobParser.parseJob(is, classLoader, new JobXmlEntityResolver(classLoader, jobXmlResolver));
            if (!jobXmlName.equals(job.getId())) {
                job.setJobXmlName(jobXmlName);
            }
            loadedJobs.add(job);
            if (!job.getInheritingJobElements().isEmpty()) {
                JobMerger.resolveInheritance(job, classLoader, loadedJobs, jobXmlResolver);
            }
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToParseJobXml(e, jobXmlName);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return job;
    }

    private static InputStream getJobXml(String jobXmlName, ClassLoader classLoader, JobXmlResolver jobXmlResolver) throws IOException {
        InputStream is;
        if (!jobXmlName.endsWith(".xml")) {
            jobXmlName = jobXmlName + ".xml";
        }
        if ((is = jobXmlResolver.resolveJobXml(jobXmlName, classLoader)) != null) {
            return is;
        }
        throw BatchMessages.MESSAGES.failToGetJobXml(jobXmlName);
    }

    private static class JobXmlEntityResolver
    implements XMLResolver {
        private final ClassLoader classLoader;
        private final JobXmlResolver jobXmlResolver;

        private JobXmlEntityResolver(ClassLoader classLoader, JobXmlResolver jobXmlResolver) {
            this.classLoader = classLoader;
            this.jobXmlResolver = jobXmlResolver;
        }

        @Override
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
            try {
                return ArchiveXmlLoader.getJobXml(systemID, this.classLoader, this.jobXmlResolver);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

