/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tools;

import java.util.HashMap;
import java.util.LinkedList;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.tools.Main;

public class TransferQueue {
    public void process(String[] arg) {
        int commit;
        int waitTimeout;
        String producingAddress;
        String targetPassword;
        String targetUser;
        int targetPort;
        String targetHost;
        String queue;
        String sourcePass;
        String sourceUser;
        int sourcePort;
        String sourceHost;
        if (arg.length != 13 && arg.length != 14) {
            System.out.println("Invalid number of arguments! " + arg.length);
            this.printUsage();
            System.exit(-1);
        }
        String filter = null;
        try {
            sourceHost = arg[1];
            sourcePort = Integer.parseInt(arg[2]);
            sourceUser = arg[3];
            sourcePass = arg[4];
            queue = arg[5];
            targetHost = arg[6];
            targetPort = Integer.parseInt(arg[7]);
            targetUser = arg[8];
            targetPassword = arg[9];
            producingAddress = arg[10];
            waitTimeout = Integer.parseInt(arg[11]);
            commit = Integer.parseInt(arg[12]);
            if (arg.length == 14) {
                filter = arg[13];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printUsage();
            System.exit(-1);
            return;
        }
        HashMap<String, Object> sourceParameters = new HashMap<String, Object>();
        sourceParameters.put("host", sourceHost);
        sourceParameters.put("port", sourcePort);
        HashMap targetParameters = new HashMap();
        sourceParameters.put("host", targetHost);
        sourceParameters.put("port", targetPort);
        try {
            ClientMessage message;
            TransportConfiguration configurationSource = new TransportConfiguration(NettyConnectorFactory.class.getName(), sourceParameters);
            ServerLocator locatorSource = HornetQClient.createServerLocator((boolean)false, (TransportConfiguration[])new TransportConfiguration[]{configurationSource});
            ClientSessionFactory factorySource = locatorSource.createSessionFactory();
            ClientSession sessionSource = factorySource.createSession(sourceUser, sourcePass, false, false, false, false, 0);
            ClientConsumer consumer = filter == null ? sessionSource.createConsumer(queue) : sessionSource.createConsumer(queue, filter);
            TransportConfiguration configurationTarget = new TransportConfiguration(NettyConnectorFactory.class.getName(), targetParameters);
            ServerLocator locatorTarget = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{configurationTarget});
            ClientSessionFactory factoryTarget = locatorTarget.createSessionFactory();
            ClientSession sessionTarget = factoryTarget.createSession(targetUser, targetPassword, false, false, false, false, 0);
            ClientProducer producer = sessionTarget.createProducer(producingAddress);
            sessionSource.start();
            int countMessage = 0;
            while ((message = consumer.receive((long)waitTimeout)) != null) {
                message.acknowledge();
                if (!message.containsProperty("_HQ_TOOL_original_address")) {
                    message.putStringProperty("_HQ_TOOL_original_address", message.getAddress().toString());
                }
                LinkedList<String> listToRemove = new LinkedList<String>();
                for (SimpleString name : message.getPropertyNames()) {
                    if (!name.toString().startsWith("_HQ_ROUTE_TO")) continue;
                    listToRemove.add(name.toString());
                }
                for (String str : listToRemove) {
                    message.removeProperty(str);
                }
                producer.send((Message)message);
                if (countMessage++ % commit != 0) continue;
                System.out.println("Sent " + countMessage + " messages");
                sessionTarget.commit();
                sessionSource.commit();
            }
            sessionTarget.commit();
            sessionSource.commit();
            consumer.close();
            producer.close();
            sessionSource.close();
            sessionTarget.close();
            locatorSource.close();
            locatorTarget.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printUsage();
            System.exit(-1);
        }
    }

    public void printUsage() {
        int i;
        for (i = 0; i < 10; ++i) {
            System.err.println();
        }
        System.err.println("This method will transfer messages from one queue into another, while removing internal properties such as ROUTE_TO.");
        System.err.println();
        System.err.println(Main.USAGE + " <source-IP> <source-port> <user> <password> <source-queue> <target-IP> <target-port> <user> <password> <target-address> <wait-timeout> <commit-size> [filter]");
        System.err.println();
        System.err.println("source-host: IP/hostname for the originating server for the messages");
        System.err.println("source-port: port for the originating server for the messages");
        System.err.println("user: Username used to connect to the source");
        System.err.println("password: Password used to connect to the source");
        System.err.println("source-port: port for the originating server for the messages");
        System.err.println("source-queue: originating queue for the messages");
        System.err.println();
        System.err.println("target-host: IP/hostname for the destination server for the messages");
        System.err.println("target-port: port for the destination server for the messages");
        System.err.println("user: Username used to connect to the target");
        System.err.println("password: Password used to connect to the target");
        System.err.println("target-address: address at the destination server");
        System.err.println();
        System.err.println("wait-timeout: time in milliseconds");
        System.err.println("commit-size: batch size for each transaction (in number of messages)");
        System.err.println();
        System.err.println("filter: You can optionally add a filter to the original queue");
        for (i = 0; i < 10; ++i) {
            System.err.println();
        }
    }
}

