/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.hibernate.MappingException;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.EmbeddedIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.MultipleIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;

public final class IdMetadataGenerator {
    private final AuditMetadataGenerator mainGenerator;

    IdMetadataGenerator(AuditMetadataGenerator auditMetadataGenerator) {
        this.mainGenerator = auditMetadataGenerator;
    }

    private boolean addIdProperties(Element parent, Iterator<Property> properties, SimpleMapperBuilder mapper, boolean key, boolean audited) {
        while (properties.hasNext()) {
            Property property = properties.next();
            Type propertyType = property.getType();
            if ("_identifierMapper".equals(property.getName())) continue;
            boolean added = false;
            added = propertyType instanceof ManyToOneType ? this.mainGenerator.getBasicMetadataGenerator().addManyToOne(parent, this.getIdPersistentPropertyAuditingData(property), property.getValue(), mapper) : this.mainGenerator.getBasicMetadataGenerator().addBasic(parent, this.getIdPersistentPropertyAuditingData(property), property.getValue(), mapper, true, key);
            if (added) continue;
            if (audited) {
                throw new MappingException("Type not supported: " + propertyType.getClass().getName());
            }
            return false;
        }
        return true;
    }

    IdMappingData addId(PersistentClass pc, boolean audited) {
        AbstractIdMapper mapper;
        DefaultElement relIdMapping = new DefaultElement("properties");
        DefaultElement origIdMapping = new DefaultElement("composite-id");
        Property idProp = pc.getIdentifierProperty();
        Component idMapper = pc.getIdentifierMapper();
        if (idMapper == null && idProp == null) {
            return null;
        }
        if (idMapper != null) {
            Class componentClass = ReflectionTools.loadClass(((Component)pc.getIdentifier()).getComponentClassName(), this.mainGenerator.getClassLoaderService());
            mapper = new MultipleIdMapper(componentClass);
            if (!this.addIdProperties((Element)relIdMapping, idMapper.getPropertyIterator(), (SimpleMapperBuilder)((Object)mapper), false, audited)) {
                return null;
            }
            if (!this.addIdProperties((Element)origIdMapping, idMapper.getPropertyIterator(), null, true, audited)) {
                return null;
            }
        } else if (idProp.isComposite()) {
            Component idComponent = (Component)idProp.getValue();
            Class embeddableClass = ReflectionTools.loadClass(idComponent.getComponentClassName(), this.mainGenerator.getClassLoaderService());
            mapper = new EmbeddedIdMapper(this.getIdPropertyData(idProp), embeddableClass);
            if (!this.addIdProperties((Element)relIdMapping, idComponent.getPropertyIterator(), (SimpleMapperBuilder)((Object)mapper), false, audited)) {
                return null;
            }
            if (!this.addIdProperties((Element)origIdMapping, idComponent.getPropertyIterator(), null, true, audited)) {
                return null;
            }
        } else {
            mapper = new SingleIdMapper();
            this.mainGenerator.getBasicMetadataGenerator().addBasic((Element)relIdMapping, this.getIdPersistentPropertyAuditingData(idProp), idProp.getValue(), (SimpleMapperBuilder)((Object)mapper), true, false);
            this.mainGenerator.getBasicMetadataGenerator().addBasic((Element)origIdMapping, this.getIdPersistentPropertyAuditingData(idProp), idProp.getValue(), null, true, true);
        }
        origIdMapping.addAttribute("name", this.mainGenerator.getVerEntCfg().getOriginalIdPropName());
        this.mainGenerator.addRevisionInfoRelation((Element)origIdMapping);
        return new IdMappingData(mapper, (Element)origIdMapping, (Element)relIdMapping);
    }

    private PropertyData getIdPropertyData(Property property) {
        return new PropertyData(property.getName(), property.getName(), property.getPropertyAccessorName(), ModificationStore.FULL);
    }

    private PropertyAuditingData getIdPersistentPropertyAuditingData(Property property) {
        return new PropertyAuditingData(property.getName(), property.getPropertyAccessorName(), ModificationStore.FULL, RelationTargetAuditMode.AUDITED, null, null, false);
    }
}

