/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBean;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.transaction.xa.XAResource;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextListener;
import org.jboss.ejb.client.EJBClientManagedTransactionContext;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.XAResourceRecovery;

public class EJBTransactionRecoveryService
implements Service<EJBTransactionRecoveryService>,
XAResourceRecovery,
EJBClientContextListener {
    private static final Logger logger = Logger.getLogger(EJBTransactionRecoveryService.class);
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"tx-recovery-service"});
    public static final EJBTransactionRecoveryService INSTANCE = new EJBTransactionRecoveryService();
    private final List<EJBReceiverContext> receiverContexts = Collections.synchronizedList(new ArrayList());
    private final InjectedValue<RecoveryManagerService> recoveryManagerService = new InjectedValue();
    private final InjectedValue<CoreEnvironmentBean> arjunaTxCoreEnvironmentBean = new InjectedValue();
    private final InjectedValue<ExecutorService> executor = new InjectedValue();

    private EJBTransactionRecoveryService() {
    }

    public void start(StartContext startContext) throws StartException {
        ((RecoveryManagerService)this.recoveryManagerService.getValue()).addXAResourceRecovery((XAResourceRecovery)this);
        logger.debugf("Registered %s with the transaction recovery manager", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext stopContext) {
        ExecutorService executorService = (ExecutorService)this.executor.getValue();
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    EJBTransactionRecoveryService.this.receiverContexts.clear();
                    ((RecoveryManagerService)EJBTransactionRecoveryService.this.recoveryManagerService.getValue()).removeXAResourceRecovery((XAResourceRecovery)EJBTransactionRecoveryService.this);
                    logger.debugf("Un-registered %s from the transaction recovery manager", (Object)this);
                }
                finally {
                    stopContext.complete();
                }
            }
        };
        try {
            executorService.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            stopContext.asynchronous();
        }
    }

    public EJBTransactionRecoveryService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource[] getXAResources() {
        List<EJBReceiverContext> list = this.receiverContexts;
        synchronized (list) {
            XAResource[] xaResources = new XAResource[this.receiverContexts.size()];
            for (int i = 0; i < this.receiverContexts.size(); ++i) {
                xaResources[i] = EJBClientManagedTransactionContext.getEJBXAResourceForRecovery((EJBReceiverContext)this.receiverContexts.get(i), (String)((CoreEnvironmentBean)this.arjunaTxCoreEnvironmentBean.getValue()).getNodeIdentifier());
            }
            return xaResources;
        }
    }

    public void contextClosed(EJBClientContext ejbClientContext) {
    }

    public void receiverRegistered(EJBReceiverContext receiverContext) {
        this.receiverContexts.add(receiverContext);
    }

    public void receiverUnRegistered(EJBReceiverContext receiverContext) {
        this.receiverContexts.remove(receiverContext);
    }

    public Injector<RecoveryManagerService> getRecoveryManagerServiceInjector() {
        return this.recoveryManagerService;
    }

    public Injector<CoreEnvironmentBean> getCoreEnvironmentBeanInjector() {
        return this.arjunaTxCoreEnvironmentBean;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executor;
    }
}

