/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jboss.net.protocol.URLLister;

public abstract class URLListerBase
implements URLLister {
    protected static final URLLister.URLFilter acceptAllFilter = new URLLister.URLFilter(){

        @Override
        public boolean accept(URL baseURL, String memberName) {
            return true;
        }
    };

    @Override
    public Collection listMembers(URL baseUrl, String patterns, boolean scanNonDottedSubDirs) throws IOException {
        StringTokenizer tokens = new StringTokenizer(patterns, ",");
        String[] members = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            members[i] = token.trim();
            ++i;
        }
        URLFilterImpl filter = new URLFilterImpl(members);
        return this.listMembers(baseUrl, filter, scanNonDottedSubDirs);
    }

    @Override
    public Collection listMembers(URL baseUrl, String patterns) throws IOException {
        return this.listMembers(baseUrl, patterns, false);
    }

    public static class URLFilterImpl
    implements URLLister.URLFilter {
        protected boolean allowAll;
        protected HashSet constants;

        public URLFilterImpl(String[] patterns) {
            this.constants = new HashSet<String>(Arrays.asList(patterns));
            this.allowAll = this.constants.contains("*");
        }

        @Override
        public boolean accept(URL baseUrl, String name) {
            if (this.allowAll) {
                return true;
            }
            return this.constants.contains(name);
        }
    }
}

