/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Collection;
import java.util.logging.Logger;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.wss4j.policy.SP12Constants;

public class SecurityVerificationOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public static final SecurityVerificationOutInterceptor INSTANCE = new SecurityVerificationOutInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(SecurityVerificationOutInterceptor.class);

    public SecurityVerificationOutInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        AssertionInfo assertion;
        AssertionInfoMap aim;
        if (MessageUtils.isRequestor((Message)message) && (aim = (AssertionInfoMap)message.get(AssertionInfoMap.class)) != null && !this.isThereASecurityBinding(aim) && (assertion = this.getSecuredPart(aim)) != null) {
            String error = String.format("%s assertion cannot be fulfilled without binding. At least one binding assertion (%s, %s, %s) must be specified in policy.", assertion.getAssertion().getName(), SP12Constants.TRANSPORT_BINDING.getLocalPart(), SP12Constants.ASYMMETRIC_BINDING.getLocalPart(), SP12Constants.SYMMETRIC_BINDING.getLocalPart());
            assertion.setNotAsserted(error);
            LOG.severe(error);
            throw new PolicyException(assertion);
        }
    }

    private boolean isThereASecurityBinding(AssertionInfoMap aim) {
        return NegotiationUtils.isThereAnAssertionByLocalname(aim, "TransportBinding") || NegotiationUtils.isThereAnAssertionByLocalname(aim, "AsymmetricBinding") || NegotiationUtils.isThereAnAssertionByLocalname(aim, "SymmetricBinding");
    }

    private AssertionInfo getSecuredPart(AssertionInfoMap aim) {
        Collection<AssertionInfo> assertions = NegotiationUtils.getAllAssertionsByLocalname(aim, "SignedParts");
        if (!assertions.isEmpty()) {
            return assertions.iterator().next();
        }
        assertions = NegotiationUtils.getAllAssertionsByLocalname(aim, "SignedElements");
        if (!assertions.isEmpty()) {
            return assertions.iterator().next();
        }
        assertions = NegotiationUtils.getAllAssertionsByLocalname(aim, "EncryptedParts");
        if (!assertions.isEmpty()) {
            return assertions.iterator().next();
        }
        assertions = NegotiationUtils.getAllAssertionsByLocalname(aim, "EncryptedElements");
        if (!assertions.isEmpty()) {
            return assertions.iterator().next();
        }
        assertions = NegotiationUtils.getAllAssertionsByLocalname(aim, "ContentEncryptedElements");
        if (!assertions.isEmpty()) {
            return assertions.iterator().next();
        }
        return null;
    }
}

