/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.simple;

import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.simple.SimpleCache;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.PassivationListener;

public class SimpleCacheFactoryService<K, V extends Identifiable<K>>
extends AbstractService<CacheFactory<K, V>>
implements CacheFactory<K, V> {
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> executor = new InjectedValue();
    private final StatefulTimeoutInfo timeout;

    public static <K, V extends Identifiable<K>> ServiceBuilder<CacheFactory<K, V>> build(String name, ServiceTarget target, ServiceName serviceName, BeanContext context, StatefulTimeoutInfo timeout) {
        SimpleCacheFactoryService<K, V> service = new SimpleCacheFactoryService<K, V>(timeout);
        return target.addService(serviceName, service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.environment).addDependency(context.getDeploymentUnitServiceName().append(new String[]{name, "expiration"}), ScheduledExecutorService.class, service.executor);
    }

    private SimpleCacheFactoryService(StatefulTimeoutInfo timeout) {
        this.timeout = timeout;
    }

    public CacheFactory<K, V> getValue() {
        return this;
    }

    @Override
    public Cache<K, V> createCache(IdentifierFactory<K> identifierFactory, StatefulObjectFactory<V> factory, PassivationListener<V> passivationListener) {
        return new SimpleCache<K, V>(factory, identifierFactory, this.timeout, (ServerEnvironment)this.environment.getValue(), (ScheduledExecutorService)this.executor.getValue());
    }
}

