/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.ClusteredGroupBuilderProvider;
import org.wildfly.clustering.spi.GroupBuilderProvider;

public class JGroupsSubsystemAddHandler
extends AbstractAddStepHandler {
    JGroupsSubsystemAddHandler() {
        super(JGroupsSubsystemResourceDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem();
        JGroupsSubsystemAddHandler.installRuntimeServices(context, operation, model);
    }

    static void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String defaultStack;
        ServiceTarget target = context.getServiceTarget();
        new ProtocolDefaultsBuilder().build(target).install();
        String defaultChannel = ModelNodes.asString((ModelNode)JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.resolveModelAttribute(context, model), (String)"default");
        if (!defaultChannel.equals("default")) {
            for (ChannelServiceName factory : ChannelServiceName.values()) {
                new AliasServiceBuilder(factory.getServiceName(), factory.getServiceName(defaultChannel), Object.class).build(target).install();
            }
            new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding("default"), ChannelServiceName.CHANNEL.getServiceName(defaultChannel), Channel.class).build(target).install();
            new AliasServiceBuilder(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName("default"), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(defaultChannel), ChannelFactory.class).build(target).install();
            new BinderServiceBuilder(JGroupsBindingFactory.createChannelFactoryBinding("default"), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(defaultChannel), ChannelFactory.class).build(target).install();
            for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(ClusteredGroupBuilderProvider.class, ClusteredGroupBuilderProvider.class.getClassLoader())) {
                Iterator groupBuilders = groupBuilderProvider.getBuilders(defaultChannel, null).iterator();
                for (Builder groupBuilder : groupBuilderProvider.getBuilders("default", null)) {
                    new AliasServiceBuilder(groupBuilder.getServiceName(), ((Builder)groupBuilders.next()).getServiceName(), Object.class).build(target).install();
                }
            }
        }
        if (!(defaultStack = ModelNodes.asString((ModelNode)JGroupsSubsystemResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, model), (String)"default-stack")).equals("default-stack")) {
            new AliasServiceBuilder(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(defaultStack), ChannelFactory.class).build(target).install();
        }
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String defaultChannel;
        context.removeService(ProtocolDefaultsBuilder.SERVICE_NAME);
        String defaultStack = ModelNodes.asString((ModelNode)JGroupsSubsystemResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, model));
        if (defaultStack != null && !defaultStack.equals("default-stack")) {
            context.removeService(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName());
        }
        if ((defaultChannel = ModelNodes.asString((ModelNode)JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.resolveModelAttribute(context, model))) != null && !defaultChannel.equals("default")) {
            for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(ClusteredGroupBuilderProvider.class, ClusteredGroupBuilderProvider.class.getClassLoader())) {
                for (Builder builder : groupBuilderProvider.getBuilders("default", null)) {
                    context.removeService(builder.getServiceName());
                }
            }
            context.removeService(JGroupsBindingFactory.createChannelFactoryBinding("default").getBinderServiceName());
            context.removeService(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName("default"));
            context.removeService(JGroupsBindingFactory.createChannelBinding("default").getBinderServiceName());
            for (ChannelServiceName factory : ChannelServiceName.values()) {
                context.removeService(factory.getServiceName());
            }
        }
    }
}

