/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.txn.subsystem.Attribute;
import org.jboss.as.txn.subsystem.Element;
import org.jboss.as.txn.subsystem.LogStoreConstants;
import org.jboss.as.txn.subsystem.Namespace;
import org.jboss.as.txn.subsystem.TransactionSubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class TransactionSubsystem13Parser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public static final TransactionSubsystem13Parser INSTANCE = new TransactionSubsystem13Parser();

    private TransactionSubsystem13Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode address = new ModelNode();
        address.add("subsystem", "transactions");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        ModelNode logStoreAddress = address.clone();
        ModelNode logStoreOperation = new ModelNode();
        logStoreOperation.get("operation").set("add");
        logStoreAddress.add("log-store", "log-store");
        logStoreAddress.protect();
        logStoreOperation.get("address").set(logStoreAddress);
        list.add(logStoreOperation);
        EnumSet<Element> required = EnumSet.of(Element.RECOVERY_ENVIRONMENT, Element.CORE_ENVIRONMENT);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        boolean choiceElementEncountered = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case TRANSACTIONS_1_3: {
                    Element element = Element.forName(reader.getLocalName());
                    required.remove((Object)element);
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case RECOVERY_ENVIRONMENT: {
                            TransactionSubsystem13Parser.parseRecoveryEnvironmentElement(reader, subsystem);
                            continue block12;
                        }
                        case CORE_ENVIRONMENT: {
                            TransactionSubsystem13Parser.parseCoreEnvironmentElement(reader, subsystem);
                            continue block12;
                        }
                        case COORDINATOR_ENVIRONMENT: {
                            TransactionSubsystem13Parser.parseCoordinatorEnvironmentElement(reader, subsystem);
                            continue block12;
                        }
                        case OBJECT_STORE: {
                            TransactionSubsystem13Parser.parseObjectStoreEnvironmentElementAndEnrichOperation(reader, subsystem);
                            continue block12;
                        }
                        case JTS: {
                            this.parseJts(reader, subsystem);
                            continue block12;
                        }
                        case USEHORNETQSTORE: {
                            if (choiceElementEncountered) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            choiceElementEncountered = true;
                            this.parseUsehornetqstore(reader, logStoreOperation);
                            subsystem.get("use-hornetq-store").set(true);
                            continue block12;
                        }
                        case JDBC_STORE: {
                            if (choiceElementEncountered) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            choiceElementEncountered = true;
                            TransactionSubsystem13Parser.parseJdbcStoreElementAndEnrichOperation(reader, subsystem);
                            subsystem.get("use-jdbc-store").set(true);
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseJts(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        operation.get("jts").set(true);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseUsehornetqstore(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        operation.get(LogStoreConstants.LOG_STORE_TYPE.getName()).set("hornetq");
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseObjectStoreEnvironmentElementAndEnrichOperation(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    TransactionSubsystemRootResourceDefinition.OBJECT_STORE_RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case PATH: {
                    TransactionSubsystemRootResourceDefinition.OBJECT_STORE_PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseJdbcStoreElementAndEnrichOperation(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE_JNDI_NAME: {
                    TransactionSubsystemRootResourceDefinition.JDBC_STORE_DATASOURCE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JDBC_ACTION_STORE: {
                    TransactionSubsystem13Parser.parseJdbcStoreConfigElementAndEnrichOperation(reader, operation, TransactionSubsystemRootResourceDefinition.JDBC_ACTION_STORE_TABLE_PREFIX, TransactionSubsystemRootResourceDefinition.JDBC_ACTION_STORE_DROP_TABLE);
                    break;
                }
                case JDBC_STATE_STORE: {
                    TransactionSubsystem13Parser.parseJdbcStoreConfigElementAndEnrichOperation(reader, operation, TransactionSubsystemRootResourceDefinition.JDBC_STATE_STORE_TABLE_PREFIX, TransactionSubsystemRootResourceDefinition.JDBC_STATE_STORE_DROP_TABLE);
                    break;
                }
                case JDBC_COMMUNICATION_STORE: {
                    TransactionSubsystem13Parser.parseJdbcStoreConfigElementAndEnrichOperation(reader, operation, TransactionSubsystemRootResourceDefinition.JDBC_COMMUNICATION_STORE_TABLE_PREFIX, TransactionSubsystemRootResourceDefinition.JDBC_COMMUNICATION_STORE_DROP_TABLE);
                }
            }
        }
    }

    static void parseJdbcStoreConfigElementAndEnrichOperation(XMLExtendedStreamReader reader, ModelNode operation, SimpleAttributeDefinition tablePrefix, SimpleAttributeDefinition dropTable) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TABLE_PREFIX: {
                    tablePrefix.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case DROP_TABLE: {
                    dropTable.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseCoordinatorEnvironmentElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLE_STATISTICS: {
                    TransactionSubsystemRootResourceDefinition.ENABLE_STATISTICS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case ENABLE_TSM_STATUS: {
                    TransactionSubsystemRootResourceDefinition.ENABLE_TSM_STATUS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case DEFAULT_TIMEOUT: {
                    TransactionSubsystemRootResourceDefinition.DEFAULT_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseCoreEnvironmentElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NODE_IDENTIFIER: {
                    TransactionSubsystemRootResourceDefinition.NODE_IDENTIFIER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case PATH: {
                    TransactionSubsystemRootResourceDefinition.PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case RELATIVE_TO: {
                    TransactionSubsystemRootResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        EnumSet<Element> required = EnumSet.of(Element.PROCESS_ID);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case PROCESS_ID: {
                    if (!encountered.add(element)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    TransactionSubsystem13Parser.parseProcessIdEnvironmentElement(reader, operation);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
    }

    static void parseProcessIdEnvironmentElement(XMLExtendedStreamReader reader, ModelNode coreEnvironmentAdd) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        boolean encountered = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case UUID: {
                    if (encountered) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    encountered = true;
                    if (reader.getAttributeCount() > 0) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
                    }
                    coreEnvironmentAdd.get(TransactionSubsystemRootResourceDefinition.PROCESS_ID_UUID.getName()).set(true);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block4;
                }
                case SOCKET: {
                    if (encountered) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    encountered = true;
                    TransactionSubsystem13Parser.parseSocketProcessIdElement(reader, coreEnvironmentAdd);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!encountered) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.UUID, Element.SOCKET));
        }
    }

    static void parseSocketProcessIdElement(XMLExtendedStreamReader reader, ModelNode coreEnvironmentAdd) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BINDING);
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case BINDING: {
                    TransactionSubsystemRootResourceDefinition.PROCESS_ID_SOCKET_BINDING.parseAndSetParameter(value, coreEnvironmentAdd, (XMLStreamReader)reader);
                    continue block4;
                }
                case SOCKET_PROCESS_ID_MAX_PORTS: {
                    TransactionSubsystemRootResourceDefinition.PROCESS_ID_SOCKET_MAX_PORTS.parseAndSetParameter(value, coreEnvironmentAdd, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseRecoveryEnvironmentElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.BINDING, Attribute.STATUS_BINDING);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case BINDING: {
                    TransactionSubsystemRootResourceDefinition.BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case STATUS_BINDING: {
                    TransactionSubsystemRootResourceDefinition.STATUS_BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case RECOVERY_LISTENER: {
                    TransactionSubsystemRootResourceDefinition.RECOVERY_LISTENER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

