/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.client.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

@ThreadSafe
public class TLSProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private X509KeyManager[] keyManagers;
    private X509TrustManager[] trustManagers;
    private SecureRandom secureRandom;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslContext;

    public TLSProtocolSocketFactory(X509KeyManager keyMgr, X509TrustManager trustMgr) throws IllegalArgumentException {
        this(keyMgr, trustMgr, null);
    }

    public TLSProtocolSocketFactory(X509KeyManager keyMgr, X509TrustManager trustMgr, HostnameVerifier verifier) throws IllegalArgumentException {
        this.keyManagers = new X509KeyManager[]{keyMgr};
        this.trustManagers = trustMgr != null ? new X509TrustManager[]{trustMgr} : null;
        this.hostnameVerifier = verifier;
        this.secureRandom = null;
        this.init();
    }

    public TLSProtocolSocketFactory(X509KeyManager[] keyMgrs, X509TrustManager[] trustMgrs, HostnameVerifier verifier, SecureRandom random) throws IllegalArgumentException {
        this.keyManagers = keyMgrs;
        this.trustManagers = trustMgrs;
        this.hostnameVerifier = verifier;
        this.secureRandom = random;
        this.init();
    }

    protected void init() throws IllegalArgumentException {
        try {
            this.sslContext = SSLContext.getInstance("SSL");
            this.sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Error create SSL context", e);
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.sslContext.getSocketFactory().createSocket(host, port);
        this.verifyHostname(socket);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int clientPort) throws IOException {
        Socket socket = this.sslContext.getSocketFactory().createSocket(host, port, localHost, clientPort);
        this.verifyHostname(socket);
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        Socket newSocket = this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        this.verifyHostname(socket);
        return newSocket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort, HttpConnectionParams connParams) throws IOException {
        if (connParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = connParams.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.sslContext.getSocketFactory();
        if (timeout == 0) {
            Socket socket = socketfactory.createSocket(host, port, localHost, localPort);
            this.verifyHostname(socket);
            return socket;
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localHost, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        this.verifyHostname(socket);
        return socket;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    protected void verifyHostname(Socket socket) throws SSLException {
        if (this.hostnameVerifier == null) {
            return;
        }
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        try {
            SSLSession sslSession = sslSocket.getSession();
            String hostname = sslSession.getPeerHost();
            if (!this.hostnameVerifier.verify(hostname, sslSession)) {
                throw new SSLPeerUnverifiedException("SSL peer failed hostname validation for name: " + hostname);
            }
        }
        catch (SSLException e) {
            this.cleanUpFailedSocket(sslSocket);
            throw e;
        }
        catch (Throwable t) {
            this.cleanUpFailedSocket(sslSocket);
            throw new SSLException("Error in hostname verification", t);
        }
    }

    protected void cleanUpFailedSocket(SSLSocket sslSocket) {
        try {
            sslSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

