/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.CopyableDeltaAware;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.atomic.impl.AtomicHashMap;
import org.infinispan.atomic.impl.AtomicHashMapDelta;
import org.infinispan.atomic.impl.AtomicHashMapProxy;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;

public class FineGrainedAtomicHashMapProxy<K, V>
extends AtomicHashMapProxy<K, V>
implements FineGrainedAtomicMap<K, V> {
    FineGrainedAtomicHashMapProxy(AdvancedCache<?, ?> cache, Object deltaMapKey) {
        super(cache, deltaMapKey);
    }

    @Override
    protected AtomicHashMap<K, V> getDeltaMapForWrite() {
        boolean lockedAndCopied;
        CacheEntry lookedUpEntry = this.lookupEntryFromCurrentTransaction();
        boolean bl = lockedAndCopied = lookedUpEntry != null && lookedUpEntry.isChanged() && this.toMap(lookedUpEntry.getValue()).copied;
        if (lockedAndCopied) {
            return this.getDeltaMapForRead();
        }
        AtomicHashMap map = this.getDeltaMapForRead();
        boolean insertNewMap = map == null;
        CopyableDeltaAware copy = insertNewMap ? new AtomicHashMap(true) : map.copy();
        ((AtomicHashMap)copy).initForWriting();
        if (insertNewMap) {
            this.cacheForWriting.put(this.deltaMapKey, copy);
        }
        return copy;
    }

    @Override
    public Set<K> keySet() {
        if (this.hasUncommittedChanges()) {
            return new HashSet<K>(this.keySetUncommitted());
        }
        CopyableDeltaAware map = this.getDeltaMapForRead().copy();
        HashSet<K> result = new HashSet<K>(this.keySetUncommitted());
        if (map != null) {
            result.addAll(((AtomicHashMap)map).keySet());
        }
        return result;
    }

    private Set<K> keySetUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? entry.getUncommittedChages().keySet() : InfinispanCollections.emptySet();
    }

    @Override
    public Collection<V> values() {
        if (this.hasUncommittedChanges()) {
            return new ArrayList<V>(this.valuesUncommitted());
        }
        CopyableDeltaAware map = this.getDeltaMapForRead().copy();
        ArrayList<V> result = new ArrayList<V>(this.valuesUncommitted());
        if (map != null) {
            result.addAll(((AtomicHashMap)map).values());
        }
        return result;
    }

    private Collection<V> valuesUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? entry.getUncommittedChages().values() : InfinispanCollections.emptySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.hasUncommittedChanges()) {
            return new HashSet<Map.Entry<K, V>>(this.entrySetUncommitted());
        }
        CopyableDeltaAware map = this.getDeltaMapForRead().copy();
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        if (map != null) {
            result.addAll(((AtomicHashMap)map).entrySet());
        }
        return result;
    }

    private Set<Map.Entry<K, V>> entrySetUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? entry.getUncommittedChages().entrySet() : InfinispanCollections.emptySet();
    }

    @Override
    public int size() {
        AtomicHashMap map = this.getDeltaMapForRead();
        int result = this.sizeUncommitted();
        if (result <= 0 && map != null) {
            return map.size();
        }
        return result;
    }

    public int sizeUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? entry.getUncommittedChages().size() : 0;
    }

    public boolean hasUncommittedChanges() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null && !entry.getUncommittedChages().isEmpty();
    }

    @Override
    public boolean isEmpty() {
        AtomicHashMap map = this.getDeltaMapForRead();
        return !this.hasUncommittedChanges() && (map == null || map.isEmpty());
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.hasUncommittedChanges()) {
            return this.containsKeyUncommitted(key);
        }
        AtomicHashMap map = this.getDeltaMapForRead();
        return map != null ? map.containsKey(key) : false;
    }

    private boolean containsKeyUncommitted(Object key) {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null && entry.getUncommittedChages().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.hasUncommittedChanges()) {
            return this.containsValueUncommitted(value);
        }
        AtomicHashMap map = this.getDeltaMapForRead();
        return map != null ? map.containsValue(value) : false;
    }

    private boolean containsValueUncommitted(Object value) {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null && entry.getUncommittedChages().containsValue(value);
    }

    @Override
    public V get(Object key) {
        V result = this.getUncommitted(key);
        if (result == null) {
            AtomicHashMap map = this.getDeltaMapForRead();
            result = map == null ? null : map.get(key);
        }
        return result;
    }

    public V getUncommitted(Object key) {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? (V)entry.getUncommittedChages().get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        AtomicHashMap<K, V> deltaMapForWrite = null;
        try {
            this.startAtomic();
            deltaMapForWrite = this.getDeltaMapForWrite();
            V toReturn = deltaMapForWrite.put(key, value);
            this.invokeApplyDelta(deltaMapForWrite.getDelta());
            V v = toReturn;
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        AtomicHashMap<K, V> deltaMapForWrite = null;
        try {
            this.startAtomic();
            deltaMapForWrite = this.getDeltaMapForWrite();
            V toReturn = deltaMapForWrite.remove(key);
            this.invokeApplyDelta(deltaMapForWrite.getDelta());
            V v = toReturn;
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        AtomicHashMap<? extends K, ? extends V> deltaMapForWrite = null;
        try {
            this.startAtomic();
            deltaMapForWrite = this.getDeltaMapForWrite();
            deltaMapForWrite.putAll(m);
            this.invokeApplyDelta(deltaMapForWrite.getDelta());
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        AtomicHashMap<K, V> deltaMapForWrite = null;
        try {
            this.startAtomic();
            deltaMapForWrite = this.getDeltaMapForWrite();
            deltaMapForWrite.clear();
            this.invokeApplyDelta(deltaMapForWrite.getDelta());
        }
        finally {
            this.endAtomic();
        }
    }

    private DeltaAwareCacheEntry lookupEntry() {
        CacheEntry entry = this.lookupEntryFromCurrentTransaction();
        if (entry instanceof DeltaAwareCacheEntry) {
            return (DeltaAwareCacheEntry)entry;
        }
        return null;
    }

    private void invokeApplyDelta(AtomicHashMapDelta delta) {
        ArrayList keys = InfinispanCollections.emptyList();
        if (delta.hasClearOperation()) {
            AtomicHashMap map = (AtomicHashMap)this.cache.get(this.deltaMapKey);
            if (map != null) {
                keys = new ArrayList(map.keySet());
            }
        } else {
            keys = delta.getKeys();
        }
        this.cache.applyDelta(this.deltaMapKey, delta, keys);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("FineGrainedAtomicHashMapProxy{deltaMapKey=");
        sb.append(this.deltaMapKey);
        sb.append("}");
        return sb.toString();
    }
}

