/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.jboss.as.jdr.logger.JdrLogger;
import org.jboss.as.jdr.util.AbstractSanitizer;
import org.jboss.vfs.VirtualFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XMLSanitizer
extends AbstractSanitizer {
    private XPathExpression expression;
    private DocumentBuilder builder;
    private Transformer transformer;

    public XMLSanitizer(String pattern, VirtualFileFilter filter) throws Exception {
        this.filter = filter;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.expression = xpath.compile(pattern);
        DocumentBuilderFactory DBfactory = DocumentBuilderFactory.newInstance();
        DBfactory.setNamespaceAware(true);
        this.builder = DBfactory.newDocumentBuilder();
        this.builder.setErrorHandler(null);
        TransformerFactory transformerFactory = TransformerFactory.newInstance("org.apache.xalan.processor.TransformerFactoryImpl", null);
        this.transformer = transformerFactory.newTransformer();
    }

    @Override
    public InputStream sanitize(InputStream in) throws Exception {
        byte[] content = IOUtils.toByteArray((InputStream)in);
        try {
            Document doc = this.builder.parse(new ByteArrayInputStream(content));
            Object result = this.expression.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            for (int i = 0; i < nodes.getLength(); ++i) {
                nodes.item(i).setTextContent("");
            }
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            StreamResult outStream = new StreamResult(output);
            this.transformer.transform(source, outStream);
            return new ByteArrayInputStream(output.toByteArray());
        }
        catch (Exception e) {
            JdrLogger.ROOT_LOGGER.debug("Error while sanitizing an xml document", e);
            return new ByteArrayInputStream(content);
        }
    }
}

