/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AuditLogHandlerReferenceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class AuditLogLoggerResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"logger", (String)"audit-log");
    public static final PathElement HOST_SERVER_PATH_ELEMENT = PathElement.pathElement((String)"server-logger", (String)"audit-log");
    public static final SimpleAttributeDefinition LOG_BOOT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("log-boot", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    public static final SimpleAttributeDefinition LOG_READ_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("log-read-only", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    static final List<SimpleAttributeDefinition> ATTRIBUTE_DEFINITIONS = Arrays.asList(LOG_BOOT, LOG_READ_ONLY, ENABLED);
    private final boolean executeRuntime;
    private final ManagedAuditLogger auditLogger;

    private AuditLogLoggerResourceDefinition(PathElement pathElement, ManagedAuditLogger auditLogger, boolean executeRuntime) {
        super(pathElement, DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.audit-log"), (OperationStepHandler)new AuditLogLoggerAddHandler(auditLogger, executeRuntime), (OperationStepHandler)new AuditLogLoggerRemoveHandler(auditLogger));
        this.auditLogger = auditLogger;
        this.executeRuntime = executeRuntime;
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    static AuditLogLoggerResourceDefinition createDefinition(ManagedAuditLogger auditLogger) {
        return new AuditLogLoggerResourceDefinition(PATH_ELEMENT, auditLogger, true);
    }

    static AuditLogLoggerResourceDefinition createHostServerDefinition(ManagedAuditLogger auditLogger) {
        return new AuditLogLoggerResourceDefinition(HOST_SERVER_PATH_ELEMENT, auditLogger, false);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)LOG_BOOT, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{LOG_BOOT}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)LOG_READ_ONLY, null, (OperationStepHandler)new AuditLogReadOnlyWriteAttributeHandler(this.auditLogger));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ENABLED, null, (OperationStepHandler)new AuditLogEnabledWriteAttributeHandler(this.auditLogger, this.executeRuntime));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new AuditLogHandlerReferenceResourceDefinition(this.auditLogger, this.executeRuntime));
    }

    public static void createServerAddOperations(List<ModelNode> addOps, PathAddress loggerAddress, ModelNode logger2) {
        addOps.add(AuditLogLoggerResourceDefinition.createLoggerAddOperation(loggerAddress, logger2));
        String handler = AuditLogHandlerReferenceResourceDefinition.PATH_ELEMENT.getKey();
        if (logger2.hasDefined(handler)) {
            for (Property prop : logger2.get(handler).asPropertyList()) {
                addOps.add(Util.createAddOperation((PathAddress)loggerAddress.append(new PathElement[]{PathElement.pathElement((String)handler, (String)prop.getName())})));
            }
        }
    }

    public static ModelNode createLoggerAddOperation(PathAddress loggerAddress, ModelNode logger2) {
        ModelNode addOp = Util.createAddOperation((PathAddress)loggerAddress);
        for (AttributeDefinition attributeDefinition : ATTRIBUTE_DEFINITIONS) {
            addOp.get(attributeDefinition.getName()).set(logger2.get(attributeDefinition.getName()));
        }
        return addOp;
    }

    class AuditLogReadOnlyWriteAttributeHandler
    extends AbstractWriteAttributeHandler<Boolean> {
        private final ManagedAuditLogger auditLogger;

        public AuditLogReadOnlyWriteAttributeHandler(ManagedAuditLogger auditLogger) {
            super(new AttributeDefinition[]{LOG_READ_ONLY});
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return AuditLogLoggerResourceDefinition.this.executeRuntime;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
            handbackHolder.setHandback((Object)this.auditLogger.isLogReadOnly());
            this.auditLogger.setLogReadOnly(resolvedValue.asBoolean());
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
            this.auditLogger.setLogReadOnly(handback.booleanValue());
        }
    }

    private static class AuditLogEnabledWriteAttributeHandler
    extends AbstractWriteAttributeHandler<AuditLogger.Status> {
        private final ManagedAuditLogger auditLogger;
        private final boolean executeRuntime;

        AuditLogEnabledWriteAttributeHandler(ManagedAuditLogger auditLogger, boolean executeRuntime) {
            super(new AttributeDefinition[]{ENABLED});
            this.auditLogger = auditLogger;
            this.executeRuntime = executeRuntime;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return this.executeRuntime;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<AuditLogger.Status> handbackHolder) throws OperationFailedException {
            handbackHolder.setHandback((Object)this.auditLogger.getLoggerStatus());
            boolean enabled = resolvedValue.asBoolean();
            AuditLogger.Status status = enabled ? AuditLogger.Status.LOGGING : AuditLogger.Status.DISABLE_NEXT;
            this.auditLogger.setLoggerStatus(status);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, AuditLogger.Status handback) throws OperationFailedException {
            this.auditLogger.setLoggerStatus(handback);
        }
    }

    private static class AuditLogLoggerRemoveHandler
    implements OperationStepHandler {
        private final ManagedAuditLogger auditLogger;

        AuditLogLoggerRemoveHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final boolean wasReadOnly = AuditLogLoggerRemoveHandler.this.auditLogger.isLogReadOnly();
                    final AuditLogger.Status oldStatus = AuditLogLoggerRemoveHandler.this.auditLogger.getLoggerStatus();
                    AuditLogLoggerRemoveHandler.this.auditLogger.setLoggerStatus(AuditLogger.Status.DISABLE_NEXT);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AuditLogLoggerRemoveHandler.this.auditLogger.setLogReadOnly(wasReadOnly);
                            AuditLogLoggerRemoveHandler.this.auditLogger.setLoggerStatus(oldStatus);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    private static class AuditLogLoggerAddHandler
    implements OperationStepHandler {
        private final ManagedAuditLogger auditLoggerProvider;
        private final boolean executeRuntime;

        AuditLogLoggerAddHandler(ManagedAuditLogger auditLoggerProvider, boolean executeRuntime) {
            this.auditLoggerProvider = auditLoggerProvider;
            this.executeRuntime = executeRuntime;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            final ModelNode model = resource.getModel();
            for (AttributeDefinition attributeDefinition : ATTRIBUTE_DEFINITIONS) {
                attributeDefinition.validateAndSet(operation, model);
            }
            if (this.executeRuntime) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final boolean wasReadOnly = AuditLogLoggerAddHandler.this.auditLoggerProvider.isLogReadOnly();
                        final AuditLogger.Status oldStatus = AuditLogLoggerAddHandler.this.auditLoggerProvider.getLoggerStatus();
                        AuditLogLoggerAddHandler.this.auditLoggerProvider.setLogBoot(LOG_BOOT.resolveModelAttribute(context, model).asBoolean());
                        AuditLogLoggerAddHandler.this.auditLoggerProvider.setLogReadOnly(LOG_READ_ONLY.resolveModelAttribute(context, model).asBoolean());
                        boolean enabled = ENABLED.resolveModelAttribute(context, model).asBoolean();
                        final AuditLogger.Status status = enabled ? AuditLogger.Status.LOGGING : AuditLogger.Status.DISABLED;
                        context.addStep(new OperationStepHandler(){

                            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                AuditLogLoggerAddHandler.this.auditLoggerProvider.setLoggerStatus(status);
                                context.completeStep(new OperationContext.RollbackHandler(){

                                    public void handleRollback(OperationContext context, ModelNode operation) {
                                        AuditLogLoggerAddHandler.this.auditLoggerProvider.setLoggerStatus(oldStatus);
                                    }
                                });
                            }
                        }, OperationContext.Stage.RUNTIME);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                AuditLogLoggerAddHandler.this.auditLoggerProvider.setLogReadOnly(wasReadOnly);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            } else {
                this.auditLoggerProvider.setLoggerStatus(AuditLogger.Status.DISABLED);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }
}

